@extends('app')
@section('pagecss')
<link href="{{URL::asset('')}}assets/vendors/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/sweetalert2/dist/sweetalert2.css" rel="stylesheet" type="text/css" />
@endsection

@section('content')
<div class="row">
  <div class="col-md-12">
	<div class="kt-portlet kt-portlet--mobile">
		<div class="kt-portlet__head kt-portlet__head--lg bg-light">
			<div class="kt-portlet__head-label">
				<span class="kt-portlet__head-icon">
					<i class="kt-font-brand flaticon2-line-chart"></i>
				</span>
				<h3 class="kt-portlet__head-title">
				{{trans("app.users-title")}}
					<small>(All Users)</small>
				</h3>
			</div>
			<div class="kt-portlet__head-toolbar">
				<div class="kt-portlet__head-wrapper">
					<div class="kt-portlet__head-actions">
						<a onclick="window.location='{{ URL::asset('')}}users/create'" class="btn text-white btn-brand btn-elevate btn-icon-sm">
							<i class="la la-plus"></i>
							Add New
						</a>
					</div>
				</div>
			</div>
		</div>
		<div class="kt-portlet__body">

			<!--begin: Datatable -->
			<table class="table table-striped- table-bordered table-hover table-checkable" id="users-view-table">
				<thead>
					<tr>
						<th>Profile Pic</th>
						<th>ID</th>
						<th>Name</th>
						<th>Email</th>
						<th>Phone</th>
						<th>Status</th>
						<th>Role</th>
						<th>Actions</th>
					</tr>
				</thead>
				<tbody>
					@if(count($users)>0)
					@foreach($users as $row)
					<tr id="user_detail_{{$row->id}}">
						<td>
							
						<div class="kt-avatar kt-avatar--outline kt-avatar--circle"  id="kt_apps_user_add_avatar">	
						@if(!$row->profilepic)
							@if($row->gender==="Male")
							<a href="{{ URL::asset('/') }}uploads/maleavatar.png" class=" img-fluid lightBoxGallery"  data-gallery="" title="{{$row->name}}"><img  class=" kt-avatar__holder img-fluid lightBoxGallery" style="width:70px; height:70px" alt="Pic"  src="{{ URL::asset('/') }}uploads/maleavatar.png" /></a>
							@else
							<a href="{{ URL::asset('/') }}uploads/femaleavatar.png" class=" img-fluid lightBoxGallery" data-gallery="" title="{{$row->name}}"><img class=" kt-avatar__holder img-fluid lightBoxGallery" style="width:70px; height:70px" alt="Pic"  src="{{ URL::asset('/') }}uploads/femaleavatar.png" /></a>
							@endif
						@else
						<a href="{{ URL::asset('/') }}uploads/{{$row->profilepic}}" class=" img-fluid lightBoxGallery"  data-gallery="" title="{{$row->name}}"><img class=" kt-avatar__holder img-fluid lightBoxGallery" style="width:70px; height:70px" alt="Pic"  src="{{ URL::asset('/') }}uploads/{{$row->profilepic}}" /></a>
						@endif
						</div>
						</td>
						<td>{{$row->id}}</td>
						<td>{{$row->name}}</td>
						<td >{{$row->email}}</td>
						<td>{{$row->phone}}</td>
						<td> @if($row->status=="on") 
							<div class="kt-badge kt-badge--inline kt-badge--pill kt-badge--info ">Active</div> 
							@else <div class="kt-badge kt-badge--inline kt-badge--pill kt-badge--success ">Deactive</div>  @endif </td>
						<td>{{$row->role}}</td>
						<td><a href="{{ URL('') }}/users/edit/{{$row->id}}" class="kt-badge kt-badge--lg kt-badge--warning"><i class="la la-edit"></i></a> &nbsp; <a onclick="deleteuser({{$row->id}})" href="javascript:;" class=" kt-badge kt-badge--lg kt-badge--danger"><i class="la la-trash"></i></a></td>
					</tr>
					@endforeach
					@endif
				</tbody>
			</table>
			<!--end: Datatable -->
		</div>
	</div>
  </div>
</div>
@endsection

@section('pagejs')
<script src="{{URL::asset('')}}assets/vendors/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.min.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/general/sweetalert2/dist/sweetalert2.min.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/custom/js/vendors/sweetalert2.init.js" type="text/javascript"></script>
<!-- <script src="{{URL::asset('/')}}assets/js/custom/users-index.js" type="text/javascript"></script> -->
<script>
$("#users-view-table").DataTable({
	// DOM Layout settings
	dom: `<'row'<'col-sm-6 text-left'l><'col-sm-6 text-right'f>>
  <'row'<'col-sm-12'tr>>
  <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
			
			scrollY: false,
			scrollX: true,
			scrollCollapse: true,

			lengthMenu: [5, 10, 25, 50,],

			pageLength: 10,

			language: {
				'lengthMenu': 'Display _MENU_',
			},

			// Order settings
			order: [[1, 'desc']],
});

function deleteuser(UserID)
{	
	swal.fire({
		title: 'Are you sure?',
		text: "You won't be able to revert this!",
		type: 'error',
		showCancelButton: true,
		confirmButtonText: 'Yes, delete it!',
		cancelButtonText: 'No, cancel!',
		reverseButtons: true
	}).then(function(result){
		if (result.value) {
			$.get("{{ route('User_delete') }}",{"_token": "{{ csrf_token() }}",UserID:UserID}).done(function(data){
				swal.fire(
				'Deleted!',
				'User has been deleted.',
				'success'
				);
				$('#user_detail_'+UserID+'').remove();	
			});
			
		} else if (result.dismiss === 'cancel') {
			swal.fire(
				'Cancelled',
				'User is safe :)',
				'error'
			)
		}
	});
}
toastr.options = {
  "closeButton": true,
  "debug": false,
  "newestOnTop": false,
  "progressBar": false,
  "positionClass": "toast-top-right",
  "preventDuplicates": false,
  "onclick": null,
  "showDuration": "300",
  "hideDuration": "1000",
  "timeOut": "5000",
  "extendedTimeOut": "1000",
  "showEasing": "swing",
  "hideEasing": "linear",
  "showMethod": "fadeIn",
  "hideMethod": "fadeOut"
};</script>
@if(Session::has("message"))
	<script>toastr.success("", "{{ Session::get("message") }}"); </script> 
@endif
@if(Session::has("error"))
<script> toastr.error("", "{{ Session::get("error") }}"); </script>
@endif
@endsection