@extends("app")
@section('pagecss')
<link href="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/select2/dist/css/select2.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/css/demo3/style.bundle.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/css/custom/user-form.css" rel="stylesheet" type="text/css" />   
@endsection
@section("content")

<div class="row">
  <div class="col-lg-12">
    <div class="kt-portlet">
      <div class="kt-portlet__head bg-light">
        <div class="kt-portlet__head-label">
          <h3 class="kt-portlet__head-title">
          {{$title}}
          </h3>
        </div>
        <div class="kt-portlet__head-toolbar">
          <div class="kt-portlet__head-wrapper">
            <a href="<?php echo $_SERVER['HTTP_REFERER'] ?>" class="btn btn-primary text-white btn-icon-sm">
            <i class="la la-long-arrow-left"></i>Back</a>
          </div>
        </div>
      </div>
      <form class="kt-form kt-form--label-right" role="form"  id="user_edit_form" action="{{ URL::asset('/') }}users/update/{{$row->id}}" enctype="multipart/form-data" method="post">
        <div class="kt-portlet__body">
          <input type="hidden" name="_token" value="{!! csrf_token() !!}">
          <input type="hidden" value="{{Auth::user()->company_id}}" name="company_id" />
          <input type="hidden" value="{{Auth::user()->country}}" name="country" />
          <input type="hidden" value="{{Auth::user()->state}}" name="state" />
          <div class="row">
          <div class="col-lg-4">
            <div class="form-group col-lg-12">
                <div class="col-lg-12 text-center">
                  <div class="kt-avatar kt-avatar--outline kt-avatar--circle" id="kt_apps_user_add_avatar">
                  @if(!$row->profilepic)
                    @if($row->gender==="Male")
                    <a href="{{ URL::asset('/') }}uploads/maleavatar.png"  class="  img-fluid lightBoxGallery" data-gallery="" title="{{$row->name}}"><img id="preview" class=" kt-avatar__holder img-fluid lightBoxGallery" width="200px" height="200px" alt="Pic"  src="{{ URL::asset('/') }}uploads/maleavatar.png" /></a>
                    @else
                    <a href="{{ URL::asset('/') }}uploads/femaleavatar.png"  class=" img-fluid lightBoxGallery" data-gallery="" title="{{$row->name}}"><img id="preview" class=" kt-avatar__holder img-fluid lightBoxGallery" width="200px" height="200px" alt="Pic"  src="{{ URL::asset('/') }}uploads/femaleavatar.png" /></a>
                    @endif
                  @else
                  <a href="{{ URL::asset('/') }}uploads/{{$row->profilepic}}"  class="  img-fluid lightBoxGallery"  data-gallery="" title="{{$row->name}}"><img id="preview"  class="kt-avatar__holder img-fluid lightBoxGallery" width="200px" height="200px" alt="Pic"  src="{{ URL::asset('/') }}uploads/{{$row->profilepic}}" /></a>    
                    @endif         
                  </div>
                </div>
              </div>
          <div class="col-lg-12 form_mb" >
            <div class="custom-file" >
              <input type="file" class="custom-file-input browse" name="profilepic" id="customFile"/>
              <label class="custom-file-label" for="customFile">{{$row->profilepic}}</label>
            </div>
            <span class="form-text text-muted">Select profile pic</span>
          </div>
          <div class="form-group col-lg-12">
          <label>Name:</label>
              <input type="text" value="{{$row->name}}" class="form-control" name="name">
              <span class="form-text text-muted">Please enter name</span>
          </div>
          <div class=" form-group col-lg-12">
            <label class="">Country:</label>
            <select class="form-control kt-select2 " id="country" name="country" onchange="get_states($(this).val())" >
              <option value="">Choose Country</option>
              @if(count($countries)>0)
                @foreach($countries as $country)
                <option value="{{$country->id}}" <?php if($country->id==$row->country){ echo 'selected="selected"';}?>>{{$country->name}}</option>
                @endforeach
              @endif
          </select>  
          </div>
          <div class="form-group col-lg-12">
            <label for="status" class="">Status:</label>
            <div class="kt-radio-inline">
                <label class="kt-radio">
                  <input type="radio" value="on" <?php if($row->status=="on"){echo 'checked="checked"';} ?> name="status">Active<span></span>
                </label>
                <label class="kt-radio">
                  <input type="radio" value="off" <?php if($row->status=="off"){echo 'checked="checked"';} ?> name="status"> Deactive
                  <span></span>
                </label>
              </div>
          </div>
        </div>
        <div class="col-lg-8">
          <div class="row">
            <div class="form-group col-lg-6">
              <label for="role" class="">Role:</label>
                <select class="form-control" id="role" name="role" onChange="accessibilities($(this).val())">
                  <!--<option></option>-->
                  @if(count($roles))
                    @foreach($roles as $role)
                    <option value="{{$role->id}}" <?php if($role->id==$row->role){echo 'selected';} ?>>{{$role->role}}</option>
                    @endforeach
                  @endif
              </select>
              <span class="form-text text-muted">Select Role</span>
            </div>
            <div class="form-group col-lg-6">
              <label class="">Email:</label>
              <input type="text" value="{{$row->email}}" class="form-control" name="email" disabled>
              <span class="form-text text-muted">Please enter email</span>
            </div>
            <div class="form-group col-lg-6">
              <label class="">Contact:</label>
              <input type="text" value="{{$row->phone}}" class="form-control" id="contact" name="phone">
              <span class="form-text text-muted">Please enter contact</span>
            </div>
            <div class=" form-group col-lg-6">
            <label class="">Gender:</label>
              <div class="kt-radio-inline">
                  <label class="kt-radio">
                    <input type="radio" value="Male" <?php if($row->gender=="Male"){echo 'checked="checked"';} ?> name="gender"> Male
                    <span></span>
                  </label>
                  <label class="kt-radio">
                    <input type="radio" value="Female" <?php if($row->gender=="Female"){echo 'checked="checked"';} ?> name="gender"> Female
                    <span></span>
                  </label>
                </div>
              <span class="form-text text-muted">Please select gender</span>
            </div>
            <div class="form-group col-lg-6">
              <label>Address:</label>
              <div class="kt-input-icon kt-input-icon--right">
              <input type="text" value="{{$row->address}}" class="form-control" name="address">
                <span class="kt-input-icon__icon kt-input-icon__icon--right"><span><i class="la la-map-marker"></i></span></span>
              </div>
              <span class="form-text text-muted">Please enter address</span>
            </div>
            <div class="form-group col-lg-6">
              <label class="">Postcode:</label>
              <div class="kt-input-icon kt-input-icon--right">
              <input type="text" value="{{$row->post_code}}" class="form-control" name="post_code">
                <span class="kt-input-icon__icon kt-input-icon__icon--right"><span><i class="la la-bookmark-o"></i></span></span>
              </div>
              <span class="form-text text-muted">Please enter postcode</span>
            </div>
            <div class="form-group col-lg-6">
                  <label class="">State:</label>
                  <select class="form-control kt-select2" id="state" name="state" onchange="get_cities($(this).val())" >
              @if(count($states)>0)
                      @foreach($states as $state)
                      <option value="{{$state->id}}" <?php if($state->id==$row->state){ echo 'selected="selected"';}?>>{{$state->name}}</option>
                      @endforeach
                      @endif
              </select>     
                </div>
                <div class=" form-group col-lg-6">
                  <label class="">City:</label>
                  <select class="form-control kt-select2" id="city" name="city" >
                      @if(count($cities)>0)
                        @foreach($cities as $city)
                          <option value="{{$city->id}}" <?php if($city->id==$row->city){ echo 'selected="selected"';}?>>{{$city->name}}</option>
                        @endforeach
                      @endif
                  </select>   
                </div>
                <?php $display = ""; if($row->role==1){$display = 'style="display:none;"';} ?>
              <div class="col-lg-6" id="accessibilities" <?php echo $display; ?>>
                <label class="">Accessibilities:</label>
                <select class="form-control kt_select2" id="access_company" name="access[]" multiple="multiple">
                <!-- <?php //$company = explode(",",$row->company_id) ?> -->
                  @if(count($companies))
                    @foreach($companies as $comp)
                    <option value="{{$comp->id}}" <?php  if($ude->exists($id, $comp->id)){ echo 'selected="selected"';}?>>{{$comp->name}}</option>
                    @endforeach
                  @endif
                </select>
              </div>             

              
            </div>
          </div>
        </div>
      </div>
        <div class="kt-portlet__foot">
          <div class="kt-form__actions">
            <div class="row">
              <div class="col-lg-5"></div>
              <div class="col-lg-6">
                <button type="submit"class="btn btn-primary">Submit</button>
                <button type="reset" class="btn btn-secondary ">Clear Changes</button>
              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
@stop
@section('pagejs')
<script src="{{URL::asset('/')}}assets/vendors/general/select2/dist/js/select2.full.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/js/scripts.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.min.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/jquery.validate.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/additional-methods.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/custom/js/vendors/jquery-validation.init.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/inputmask/dist/jquery.inputmask.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/inputmask/dist/inputmask/inputmask.numeric.extensions.js" type="text/javascript"></script>
<!-- <script src="{{URL::asset('/')}}assets/js/custom/edit-user-form.js" type="text/javascript"></script> -->
<script>
function get_states(id){
    $.get("{{ route('Get_states') }}", {id:id, _token:"{{ csrf_token() }}"}).done(function(e){
      $("#state").html(e);
    });
  }
  function get_cities(id){
    $.get("{{ route('Get_cities') }}", {id:id, _token:"{{ csrf_token() }}"}).done(function(e){
      $("#city").html(e);
    });
  }
  $('#country,#state,#city,#access_company').select2({
      placeholder: "Select.."
  });
  $("#contact").inputmask("mask", {
      "mask": "+(99) 999-9999999"
  }); 
  function departments(e, id){
    if(e.is(":checked")){
    }else{
      $("#departments_"+id).hide();
    }
  }
  function accessibilities(role){
    if(role==1){
      $("#accessibilities").hide();
    }
    if(role==2){
      $(".departments").attr("type", "checkbox");
      $("#accessibilities").show();
    }
    if(role==3){
      $(".departments").attr("type", "radio");
      $("#accessibilities").show();
    }
  }
    $(document).on("click", ".browse", function() {
      var file = $(this).parents().find(".file");
      file.trigger("click");
    });
  $('input[type="file"]').change(function(e) {
    var fileName = e.target.files[0].name;
    $("#file").val(fileName);
    var reader = new FileReader();
    reader.onload = function(e) {
      // get loaded data and render thumbnail.
      document.getElementById("preview").src = e.target.result;
    };
    // read the image file as a data URL.
    reader.readAsDataURL(this.files[0]);
  });
  $( "#user_edit_form" ).validate({
    // define validation rules
    rules: {
        name: {
                required: true 
            },
        email: {
            required: true,
            email: true,
            minlength: 10 
        },
        phone: {
            required: true 
        },
        country: {
            required: true,
        },
        state: {
            required: true,
        },
        city: {
            required: true,
        },
        gender: {
            required: true
        },
        address: {
            required: true
        },
        post_code: {
            required: true
        },
        status: {
            required: true
        },
        password: {
            required: true
        },
        role: {
            required: true
        }
    },
    //display error alert on form submit  
    invalidHandler: function(event, validator) {     
       
    },
  
    submitHandler: function (form) {
        form[0].submit(); // submit the form
    }
  });
</script>
@if($errors->any())
  @foreach($errors->all() as $error)
    <script>toastr.warning("", "{{$error}}"); </script> 
  @endforeach
@endif
@if(Session::has("message"))
  <script>toastr.success("", "{{ Session::get("message") }}"); </script> 
@endif
@if(Session::has("error"))
  <script> toastr.error("", "{{ Session::get("error") }}"); </script>
@endif
@endsection
