@extends('app')
@section('pagecss')
<link href="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/select2/dist/css/select2.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/css/demo3/style.bundle.css" rel="stylesheet" type="text/css" /> 
<link href="{{URL::asset('')}}assets/css/custom/user-form.css" rel="stylesheet" type="text/css" /> 
<link href="{{URL::asset('')}}assets/vendors/custom/jstree/jstree.bundle.css" rel="stylesheet" type="text/css" />  
@endsection

@section('content')
<div class="row">
 <div class="col-lg-12">
  <div class="kt-portlet">
    <div class="kt-portlet__head bg-light">
      <div class="kt-portlet__head-label">
        <h3 class="kt-portlet__head-title ">
        {{$title}}
        </h3>
      </div>
      <div class="kt-portlet__head-toolbar">
          <div class="kt-portlet__head-wrapper">
            <a href="<?php echo $_SERVER['HTTP_REFERER'] ?>" class="btn btn-primary text-white btn-icon-sm">
            <i class="la la-long-arrow-left"></i>Back</a>
          </div>
        </div>
    </div>
<!--begin::Form-->
    <form class="kt-form kt-form--label-right" role="form" id="user_create_form" action="{{ URL('users/store') }}" enctype="multipart/form-data" method="post">
      <div class="kt-portlet__body">
        <input type="hidden" name="_token" value="{!! csrf_token() !!}">
        <input type="hidden" value="{{Auth::user()->company_id}}" name="company_id" />
        <input type="hidden" value="{{Auth::user()->country}}" name="country" />
        <input type="hidden" value="{{Auth::user()->state}}" name="state" />
        <div class="row">
          <div class="col-lg-4">
            <div class="form-group col-lg-12">
              <!-- <label class="col-lg-12 col-form-label text-center">Profile Picture</label> -->
              <div class="col-lg-12 text-center">
                <div class="kt-avatar kt-avatar--outline kt-avatar--circle" id="kt_apps_user_add_avatar">
                <img src="{{ URL::asset('') }}uploads/maleavatar.png" class="kt-avatar__holder img-fluid lightBoxGallery " id="preview" alt="pic">
                </div>
              </div>
            </div>
            
            <div class="col-lg-12 form_mb" >
              <!-- <label>Profile Pic</label> -->
              <div class="custom-file " >
                <input type="file" class="custom-file-input browse" name="profilepic" id="customFile"/>
                <label class="custom-file-label" for="customFile"></label>
              </div>
              <span class="form-text text-muted">Select profile pic</span>
            </div>
            <div class="form-group col-lg-12">
            <label>Name:</label>
                <input type="text"   value="{{old('name')}}" class="form-control" name="name">
                <span class="form-text text-muted">Please enter name</span>
            </div>
            <div class=" form-group col-lg-12">
              <label class="">Country:</label>
              <select class="form-control kt-select2" id="country" name="country" onchange="get_states($(this).val())" >
                  <option value="">Choose Country</option>
                  @if(count($countries)>0)
                    @foreach($countries as $country)
                      <option value="{{$country->id}}">{{$country->name}}</option>
                    @endforeach
                  @endif
              </select> 
            </div>
            <div class="form-group col-lg-12">
              <label for="status" class="">Status:</label>
                <div class="kt-radio-inline">
                  <label class="kt-radio">
                    <input type="radio" value="on" checked name="status"> Active
                    <span></span>
                  </label>
                  <label class="kt-radio">
                    <input type="radio" value="off"   name="status"> Deactive
                    <span></span>
                  </label>
                </div>
            </div>
          </div>
          <div class="col-lg-8">
            <div class="row">
              <div class="form-group col-lg-6">
              <label class="">Email:</label>
                <input type="email" value="{{ old('email') }}" class="form-control" name="email">
                <span class="form-text text-muted">Please enter email</span>
              </div>
              <div class="form-group col-lg-6">
              <label class="">Password:</label>
              <input type="password" value=""   class="form-control" name="password">
              <span class="form-text text-muted">Please enter password</span>
              </div>
              <div class="form-group col-lg-6">
                <label class="">Contact:</label>
                <input type="text"   value="{{old('phone')}}" id="contact" class="form-control" name="phone">
                <span class="form-text text-muted">Please enter contact</span>
              </div>
              <div class=" form-group col-lg-6">
                <label>Gender</label>
                <div class="kt-radio-inline">
                  <label class="kt-radio">
                    <input type="radio" value="Male"    name="gender"> Male
                    <span></span>
                  </label>
                  <label class="kt-radio">
                    <input type="radio" value="Female"   name="gender"> Female
                    <span></span>
                  </label>
                </div>
                <span class="form-text text-muted">Please select gender</span>
              </div>
              <div class="form-group col-lg-6">
                <label>Address:</label>
                <div class="kt-input-icon kt-input-icon--right">
                <input type="text" value="{{old('address')}}"   class="form-control" name="address">
                  <span class="kt-input-icon__icon kt-input-icon__icon--right"><span><i class="la la-map-marker"></i></span></span>
                </div>
                <span class="form-text text-muted">Please enter address</span>
              </div>
            
              <div class="form-group col-lg-6">
                <label class="">Postcode:</label>
                <div class="kt-input-icon kt-input-icon--right">
                <input type="text" value="{{ old('post_code') }}"   class="form-control" name="post_code">
                  <span class="kt-input-icon__icon kt-input-icon__icon--right"><span><i class="la la-bookmark-o"></i></span></span>
                </div>
                <span class="form-text text-muted">Please enter postcode</span>
              </div>
              <div class="form-group col-lg-6">
                <label class="">State:</label>
                <select class="form-control kt-select2" id="state" name="state" onchange="get_cities($(this).val())" >
                    <option value="">Choose State</option>
                </select>   
              </div>
              <div class=" form-group col-lg-6">
                <label class="">City:</label>
                <select class="form-control kt-select2" id="city" name="city" >
                    <option value="">Choose city</option>
                </select>   
              </div>
              <div class=" form-group col-lg-6">
                <label for="role" class="">Role:</label>
                <select class="form-control "  id="role" name="role" onChange="accessibilities($(this).val())">
                  <option value="">Choose Role</option>
                  @if(count($roles))
                  @foreach($roles as $row)
                  <option value="{{$row->id}}">{{$row->role}}</option>
                  @endforeach
                  @endif
                </select>
              </div>
              <div class="form-group col-lg-6" id="accessibilities"   >
                <label class="">Accessibilities:</label>
                <select class="form-control kt_select2" id="access_company" name="access[]" multiple="multiple">
                <option value="">Select</option>
                @if(count($companies))
                  @foreach($companies as $row)
                  <option value="{{$row->id}}">{{$row->name}}</option>
                  @endforeach
                @endif
                </select>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="kt-portlet__foot">
        <div class="kt-form__actions">
          <div class="row">
            <div class="col-lg-5"></div>
            <div class="col-lg-6">
              <button type="submit"class="btn btn-primary">Submit</button>
              <button type="reset" class="btn btn-secondary">Clear</button>
            </div>
          </div>
        </div>
      </div>
    </form>
    </div>
    <!--end::Form-->
  </div>
</div>
@endsection

@section('pagejs')
<script src="{{URL::asset('/')}}assets/vendors/general/select2/dist/js/select2.full.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/js/scripts.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/inputmask/dist/jquery.inputmask.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/inputmask/dist/inputmask/inputmask.numeric.extensions.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/toastr/build/toastr.min.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/jquery.validate.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/additional-methods.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/custom/js/vendors/jquery-validation.init.js" type="text/javascript"></script>

<!-- <script src="{{URL::asset('/')}}assets/js/custom/create-user-form.js" type="text/javascript"></script> -->
<script>

function get_states(id){
    $.get("{{ route('Get_states') }}", {id:id, _token:"{{ csrf_token() }}"}).done(function(e){
        $("#state").html(e);
    });
}
function get_cities(id){
    $.get("{{ route('Get_cities') }}", {id:id, _token:"{{ csrf_token() }}"}).done(function(e){
        $("#city").html(e);
    });
}
$("#contact").inputmask("mask", {
"mask": "+(99) 999-9999999"
}); 
$('#country,#state,#city,#access_company').select2({
placeholder: "Select.."
});
function departments(e, id){
    if(e.is(":checked")){
        
    }else{
        
        $("#departments_"+id).hide();
    }
}
function accessibilities(role){
    if(role==1){
        $("#accessibilities").hide();
    }
    if(role==2){
        $(".departments").attr("type", "checkbox");
        $("#accessibilities").show();
    }
    if(role==3){
        $(".departments").attr("type", "radio");
        $("#accessibilities").show();
    }
}
$(document).on("click", ".browse", function() {
var file = $(this).parents().find(".file");
file.trigger("click");
});
$('input[type="file"]').change(function(e) {
var fileName = e.target.files[0].name;
$("#file").val(fileName);

var reader = new FileReader();
reader.onload = function(e) {
// get loaded data and render thumbnail.
document.getElementById("preview").src = e.target.result;
};
// read the image file as a data URL.
reader.readAsDataURL(this.files[0]);
});
toastr.options = {
"closeButton": true,
"debug": false,
"newestOnTop": false,
"progressBar": false,
"positionClass": "toast-top-center",
"preventDuplicates": false,
"onclick": null,
"showDuration": "300",
"hideDuration": "1000",
"timeOut": "5000",
"extendedTimeOut": "1000",
"showEasing": "swing",
"hideEasing": "linear",
"showMethod": "fadeIn",
"hideMethod": "fadeOut"
};

$( "#user_create_form" ).validate({
// define validation rules
rules: {
  name: {
          required: true 
      },
  email: {
      required: true,
      email: true,
      minlength: 10 
  },
  phone: {
      required: true 
  },
  country: {
      required: true,
  },
  state: {
      required: true,
  },
  gender: {
      required: true
  },
  address: {
      required: true
  },
  post_code: {
      required: true
  },
  status: {
      required: true
  },
  password: {
      required: true
  },
  role: {
      required: true
  }
},
//display error alert on form submit  
invalidHandler: function(event, validator) {     
},

submitHandler: function (form) {
  form[0].submit(); // submit the form
}
});</script>

@if($errors->any())
  @foreach($errors->all() as $error)
   <script>toastr.warning("", "{{$error}}"); </script> 
  @endforeach
@endif
@if(Session::has("message"))
  <script>toastr.success("", "{{ Session::get("message") }}"); </script> 
@endif
@if(Session::has("error"))
  <script> toastr.error("", "{{ Session::get("error") }}"); </script>
@endif
@endsection