@extends('app')
@section('pagecss')
<link href="{{URL::asset('')}}assets/vendors/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/select2/dist/css/select2.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/css/demo3/style.bundle.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/sweetalert2/dist/sweetalert2.css" rel="stylesheet" type="text/css" />
@endsection

@section("content")
<div class="row">
  <div class="col-md-12">
    <div class="kt-portlet kt-portlet--mobile">
      <div class="kt-portlet__body">
        <form name="my_form" class="kt-form kt-form--label-right" >
          <div class=" form-group row">
            <div class="col-lg-2">
                <div class="kt-portlet__head">
                  <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">Filters</h3>
                  </div>
                </div>
              </div>
              <div class="col-lg-4">
                <label>Department</label>
                <select name="department" class="kt-select_2 form-control" id="department_select" >
                  <option value="0" <?php if(isset($_GET['department'])){  if($_GET['department']==0){ echo 'selected="selected"'; }}?> >All</option>
                  @foreach($com_category as $cat)
                  <option value="{{$cat->id}}" <?php if(isset($_GET['department'])){  if($_GET['department']==$cat->id){ echo 'selected="selected"'; }}?> >{{$cat->name}}</option>
                  @endforeach 
                </select>
              </div>
              <div class="col-lg-4">
                <label>Period   </label>
                <select name="period" id="period_select" class=" form-control">
                  <option value="0" <?php if(isset($_GET['period'])){  if($_GET['period']==0){ echo 'selected="selected"'; }}?> >All</option>     
                  @foreach($periods as $p)
                  <option value="{{$p->p_id}}" <?php if(isset($_GET['period'])){  if($_GET['period']==$p->p_id){ echo 'selected="selected"'; }}?> >{{$p->p_name}}</option>
                  @endforeach   
              </select>
              </div>
              <div class="col-lg-2">
                <input type="hidden" name="_token" value="{!! csrf_token() !!}"><br>
                <input style="margin-top:5px;" class="btn btn-primary form-control" type="submit" name="submit" value="Submit"/>
              </div>
            </div>
          </div>
        </form>
        <div class="kt-portlet kt-portlet--mobile">
          <div class="kt-portlet__head kt-portlet__head--lg">
            <div class="kt-portlet__head-label">
              <span class="kt-portlet__head-icon">
                <i class="kt-font-brand flaticon2-line-chart"></i>
              </span>
              <h3 class="kt-portlet__head-title">
            Expense Reports
              </h3>
            </div>
            <div class="kt-portlet__head-toolbar">
              <div class="kt-portlet__head-wrapper">
                <div class="kt-portlet__head-actions">
                &nbsp;
                <!-- <a href="{{ url('expenses/create') }}" class="btn btn-brand btn-icon-sm">
                    <i class="flaticon2-plus"></i> Add New
                  </a> -->
                </div>
              </div>
            </div>
          </div>
          <div class="kt-portlet__body">
           <table class="table table-striped- table-bordered table-hover table-checkable" id="expense-report-table">
              <thead>
                <tr>
                  <th>Period Name</th>
                  <th>Department</th>
                  <th>Subject</th>
                  <th>Amount</th>
                  <th>Status</th>
                </tr>
              </thead>
              <tbody>
                @if(count($expense_filter)>0)
                  @foreach($expense_filter as $exp) 
                    <tr>
                      <td>{{$exp->p_nam}}</td> 
                      <td>{{$exp->cat}}</td>
                      <td>{{$exp->sub}}</td>
                      <td class="dt-body-right"> {{\App\Providers\Common::format_currency($exp->e_price)}}</td>
                      <td>{{$exp->sat}}</td>
                    </tr>  
                  @endforeach
                @endif
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
</div>
@endsection
@section('pagejs')
<script src="{{URL::asset('')}}assets/vendors/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.min.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/general/sweetalert2/dist/sweetalert2.min.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/custom/js/vendors/sweetalert2.init.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/select2/dist/js/select2.full.js" type="text/javascript"></script>
<script src="{{URL::asset('assets/js/custom/expense-report.js')}}"></script>

@if(Session::has("message"))
	<script> success_toastr("{{ Session::get('message') }}"); </script> 
@endif
@if(Session::has("error"))
<script> error_toastr("{{ Session::get('error') }}"); </script>
@endif
@endsection






















        
        
        						
		

