@extends("app")
@section("pagecss")
<link href="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/css/demo3/style.bundle.css" rel="stylesheet" type="text/css" />  
@endsection
@section("content")

<div class="row">
  <div class="col-lg-12">
    <div class="kt-portlet">
      <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
          <h3 class="kt-portlet__head-title">
          {{$title}}
          </h3>
        </div>
        <div class="kt-portlet__head-toolbar">
				  <div class="kt-portlet__head-wrapper">
								<a href="<?php echo $_SERVER['HTTP_REFERER'] ?>" class="btn btn-primary text-white btn-icon-sm">
							<i class="la la-long-arrow-left"></i>Back</a>
          </div>
        </div>
      </div>
      
	<!--begin::Form-->
      <form class="kt-form kt-form--label-right" id="profile_form"role="form" action="{{ URL::asset('/') }}profile/edit/{{$profile->id}}" method="post" enctype="multipart/form-data">
        <div class="kt-portlet__body">
        <input type="hidden" name="_token" value="{!! csrf_token() !!}">
          <div class=" row">
            <div class="form-group col-lg-4">
              <label>Name:</label>
              <input type="text" value="{{$profile->name}}" class="form-control" name="name">
              <span class="form-text text-muted">Please enter your name</span>
            </div>
            <div class="form-group col-lg-4">
              <label class="">Email:</label>
              <input type="text" value="{{$profile->email}}" disabled class="form-control" name="email">
              <span class="form-text text-muted">Please enter your email</span>
            </div>
            <div class="form-group col-lg-4">
              <label class="">Contact:</label>
              <input type="text" value="{{$profile->phone}}" class="form-control" id="contact" name="phone">
              <span class="form-text text-muted">Please enter your contact</span>
            </div>
          </div>
          <div class="row">
            <div class="form-group form-group col-lg-4">
              <label>Address:</label>
              <div class="kt-input-icon kt-input-icon--right">
              <input type="text" value="{{$profile->address}}" class="form-control" name="address">
                <span class="kt-input-icon__icon kt-input-icon__icon--right"><span><i class="la la-map-marker"></i></span></span>
              </div>
              <span class="form-text text-muted">Please enter your address</span>
            </div>
            <div class=" form-group col-lg-4">
              <label class="">Postcode:</label>
              <div class="kt-input-icon kt-input-icon--right">
              <input type="text" value="{{$profile->post_code}}" class="form-control" name="post_code">
                <span class="kt-input-icon__icon kt-input-icon__icon--right"><span><i class="la la-bookmark-o"></i></span></span>
              </div>
              <span class="form-text text-muted">Please enter your postcode</span>
            </div>
            <div class=" col-lg-4">
              <label>Avatar</label>
              <div class="custom-file" >
                <input type="file" class="custom-file-input" name="profilepic" id="customFile"/>
                <label class="custom-file-label" for="customFile"><?php echo $profile->logo;?></label>
              </div>
              <span class="form-text text-muted">Select profile pic</span>
            </div>
          </div>
        </div>
        <div class="kt-space-40"></div>   
        <div class="kt-portlet__foot">
          <div class="kt-form__actions">
            <div class="row">
              <div class="col-lg-5"></div>
              <div class="col-lg-6">
                <button type="submit"class="btn btn-primary">Submit</button>
                <button type="reset" class="btn btn-secondary">Clear Changes</button>
              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
</div>
@stop
@section("pagejs")
<script src="{{URL::asset('/')}}assets/vendors/general/select2/dist/js/select2.full.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/js/scripts.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.min.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/jquery.validate.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/additional-methods.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/custom/js/vendors/jquery-validation.init.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/inputmask/dist/jquery.inputmask.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/inputmask/dist/inputmask/inputmask.numeric.extensions.js" type="text/javascript"></script>
<script>
  $("#contact").inputmask("mask", {
    "mask": "+(99) 999-9999999"
}); 
$( "#profile_form" ).validate({
  // define validation rules
  rules: {
      name: {
              required: true 
          },
      email: {
          required: true,
          email: true,
          minlength: 10 
      },
      phone: {
          required: true 
      },
      address: {
          required: true
      },
      post_code: {
          required: true
      }
  },
  //display error alert on form submit  
  invalidHandler: function(event, validator) {     
  },

  submitHandler: function (form) {
      form[0].submit(); // submit the form
  }
});
</script>
@if($errors->any())
  @foreach($errors->all() as $error)
    <script>toastr.warning("", "{{$error}}"); </script> 
  @endforeach
@endif
@if(Session::has("message"))
  <script>toastr.success("", "{{ Session::get("message") }}"); </script> 
@endif
@if(Session::has("error"))
  <script> toastr.error("", "{{ Session::get("error") }}"); </script>
@endif
@endsection