@extends('app')
@section('pagecss')
<link href="{{URL::asset('')}}assets/vendors/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/select2/dist/css/select2.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/css/demo3/style.bundle.css" rel="stylesheet" type="text/css"/>
<link href="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.css" rel="stylesheet" type="text/css" /> 
<link href="{{URL::asset('')}}assets/css/custom/home-index.css" rel="stylesheet" type="text/css" /> 

@endsection
@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="row" style=" overflow:hidden;">
            <div class="col-xl-4" >
                <div class="row">
                    <div class="col-xl-12" >
                        <div class="kt-portlet kt-portlet--fit kt-portlet--head-lg kt-portlet--head-overlay kt-portlet--skin-solid kt-portlet--height-fluid" >
                            <div class="kt-portlet__head kt-portlet__head--noborder kt-portlet__space-x">
                                <div class="kt-portlet__head-label">
                                    <h3 class="kt-portlet__head-title">
                                        Expense Summary
                                    </h3>
                                </div>
                            </div>
                            <div class="kt-portlet__body kt-portlet__body--fit">
                                <div class="kt-widget17">
                                    <div class="kt-widget17__visual kt-widget17__visual--chart kt-portlet-fit--top kt-portlet-fit--sides" style="background-image:  url({{URL::asset('/')}}assets/media/bg/homeimg1.jpg); background-size: cover;">
                                        <div class="kt-widget17__chart" style="height: 200px;">
                                            <canvas id="kt_chart_activities"></canvas>
                                        </div>
                                    </div>
                                    <div class="kt-widget17__stats">
                                        <div class="kt-widget17__items">
                                            <div class="kt-widget17__item" style="margin-top:-40px;">
                                                <a href="{{ URL::asset('/') }}expenses?department=all&status=Pending&period=all&page=">
                                                    <span class="kt-widget17__icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-svg-icon--warning">
                                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                            <rect id="bound" x="0" y="0" width="24" height="24" />
                                                            <path d="M12.7037037,14 L15.6666667,10 L13.4444444,10 L13.4444444,6 L9,12 L11.2222222,12 L11.2222222,14 L6,14 C5.44771525,14 5,13.5522847 5,13 L5,3 C5,2.44771525 5.44771525,2 6,2 L18,2 C18.5522847,2 19,2.44771525 19,3 L19,13 C19,13.5522847 18.5522847,14 18,14 L12.7037037,14 Z" id="Combined-Shape" fill="#000000" opacity="0.3" />
                                                            <path d="M9.80428954,10.9142091 L9,12 L11.2222222,12 L11.2222222,16 L15.6666667,10 L15.4615385,10 L20.2072547,6.57253826 C20.4311176,6.4108595 20.7436609,6.46126971 20.9053396,6.68513259 C20.9668779,6.77033951 21,6.87277228 21,6.97787787 L21,17 C21,18.1045695 20.1045695,19 19,19 L5,19 C3.8954305,19 3,18.1045695 3,17 L3,6.97787787 C3,6.70173549 3.22385763,6.47787787 3.5,6.47787787 C3.60510559,6.47787787 3.70753836,6.51099993 3.79274528,6.57253826 L9.80428954,10.9142091 Z" id="Combined-Shape" fill="#000000" />
                                                        </g>
                                                    </svg> </span>
                                                    <span class="kt-widget17__subtitle">
                                                    Pending
                                                    </span>
                                                    <span class="kt-widget17__desc">
                                                    <?php  echo $Pending; ?> Requests
                                                    </span>
                                                </a>
                                                </div>
                                                <div class="kt-widget17__item" style="margin-top:-40px;">
                                                    <a href="{{ URL::asset('/') }}expenses?department=all&status=Approved&period=all&page=">
                                                    <span class="kt-widget17__icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-svg-icon--success">
                                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                <polygon id="Bound" points="0 0 24 0 24 24 0 24" />
                                                                <path d="M12.9336061,16.072447 L19.36,10.9564761 L19.5181585,10.8312381 C20.1676248,10.3169571 20.2772143,9.3735535 19.7629333,8.72408713 C19.6917232,8.63415859 19.6104327,8.55269514 19.5206557,8.48129411 L12.9336854,3.24257445 C12.3871201,2.80788259 11.6128799,2.80788259 11.0663146,3.24257445 L4.47482784,8.48488609 C3.82645598,9.00054628 3.71887192,9.94418071 4.23453211,10.5925526 C4.30500305,10.6811601 4.38527899,10.7615046 4.47382636,10.8320511 L4.63,10.9564761 L11.0659024,16.0730648 C11.6126744,16.5077525 12.3871218,16.5074963 12.9336061,16.072447 Z" id="Shape" fill="#000000" fill-rule="nonzero" />
                                                                <path d="M11.0563554,18.6706981 L5.33593024,14.122919 C4.94553994,13.8125559 4.37746707,13.8774308 4.06710397,14.2678211 C4.06471678,14.2708238 4.06234874,14.2738418 4.06,14.2768747 L4.06,14.2768747 C3.75257288,14.6738539 3.82516916,15.244888 4.22214834,15.5523151 C4.22358765,15.5534297 4.2250303,15.55454 4.22647627,15.555646 L11.0872776,20.8031356 C11.6250734,21.2144692 12.371757,21.2145375 12.909628,20.8033023 L19.7677785,15.559828 C20.1693192,15.2528257 20.2459576,14.6784381 19.9389553,14.2768974 C19.9376429,14.2751809 19.9363245,14.2734691 19.935,14.2717619 L19.935,14.2717619 C19.6266937,13.8743807 19.0546209,13.8021712 18.6572397,14.1104775 C18.654352,14.112718 18.6514778,14.1149757 18.6486172,14.1172508 L12.9235044,18.6705218 C12.377022,19.1051477 11.6029199,19.1052208 11.0563554,18.6706981 Z" id="Path" fill="#000000" opacity="0.3" />
                                                            </g>
                                                        </svg>
                                                    </span>
                                                    <span class="kt-widget17__subtitle">
                                                    Approved
                                                    </span>
                                                    <span class="kt-widget17__desc">
                                                    <?php echo $Approved; ?> Requests
                                                    </span>
                                                </a>
                                            </div>
                                        </div>
                                        <div class="kt-widget17__items">
                                            <div class="kt-widget17__item">
                                                <a href="{{ URL::asset('/') }}expenses?department=all&status=Overdue&period=all&page=">
                                                    <span class="kt-widget17__icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-svg-icon--brand">
                                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                <rect id="bound" x="0" y="0" width="24" height="24" />
                                                                <path d="M5,3 L6,3 C6.55228475,3 7,3.44771525 7,4 L7,20 C7,20.5522847 6.55228475,21 6,21 L5,21 C4.44771525,21 4,20.5522847 4,20 L4,4 C4,3.44771525 4.44771525,3 5,3 Z M10,3 L11,3 C11.5522847,3 12,3.44771525 12,4 L12,20 C12,20.5522847 11.5522847,21 11,21 L10,21 C9.44771525,21 9,20.5522847 9,20 L9,4 C9,3.44771525 9.44771525,3 10,3 Z" id="Combined-Shape" fill="#000000" />
                                                                <rect id="Rectangle-Copy-2" fill="#000000" opacity="0.3" transform="translate(17.825568, 11.945519) rotate(-19.000000) translate(-17.825568, -11.945519) " x="16.3255682" y="2.94551858" width="3" height="18" rx="1" />
                                                            </g>
                                                        </svg> 
                                                    </span>
                                                    <span class="kt-widget17__subtitle">
                                                    Overdue
                                                    </span>
                                                    <span class="kt-widget17__desc">
                                                    <?php echo $Overdue;?> Requests
                                                    </span>
                                                </a>
                                            </div>
                                            <div class="kt-widget17__item">
                                                <a href="{{ URL::asset('/') }}expenses?department=all&status=Closed&period=all&page=">
                                                    <span class="kt-widget17__icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-svg-icon--dark">
                                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                <rect id="bound" x="0" y="0" width="24" height="24" />
                                                                <path d="M3,16 L5,16 C5.55228475,16 6,15.5522847 6,15 C6,14.4477153 5.55228475,14 5,14 L3,14 L3,12 L5,12 C5.55228475,12 6,11.5522847 6,11 C6,10.4477153 5.55228475,10 5,10 L3,10 L3,8 L5,8 C5.55228475,8 6,7.55228475 6,7 C6,6.44771525 5.55228475,6 5,6 L3,6 L3,4 C3,3.44771525 3.44771525,3 4,3 L10,3 C10.5522847,3 11,3.44771525 11,4 L11,19 C11,19.5522847 10.5522847,20 10,20 L4,20 C3.44771525,20 3,19.5522847 3,19 L3,16 Z" id="Combined-Shape" fill="#000000" opacity="0.3" />
                                                                <path d="M16,3 L19,3 C20.1045695,3 21,3.8954305 21,5 L21,15.2485298 C21,15.7329761 20.8241635,16.200956 20.5051534,16.565539 L17.8762883,19.5699562 C17.6944473,19.7777745 17.378566,19.7988332 17.1707477,19.6169922 C17.1540423,19.602375 17.1383289,19.5866616 17.1237117,19.5699562 L14.4948466,16.565539 C14.1758365,16.200956 14,15.7329761 14,15.2485298 L14,5 C14,3.8954305 14.8954305,3 16,3 Z" id="Rectangle-102-Copy" fill="#000000" />
                                                            </g>
                                                        </svg> </span>
                                                    <span class="kt-widget17__subtitle">
                                                        Closed
                                                    </span>
                                                    <span class="kt-widget17__desc">
                                                        <?php echo $Closed; ?> Requests
                                                    </span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12">
                        <div class="kt-portlet kt-portlet--height-fluid">
                            <div class="kt-portlet__head bg-light" >
                                <div class="kt-portlet__head-label ">
                                    <h3 class="kt-portlet__head-title ">
                                        Budget Information
                                        <small class="">Total budget</small>
                                    </h3>
                                </div>
                                <div class="kt-portlet__head-toolbar">
                                </div>
                            </div>
                            <div class="kt-portlet__body">
                                <div class="kt-widget25">
                                    <span class="kt-widget25__stats text-success">
                                    @if(count($budgets)>0)
                                            {{\App\Providers\Common::format_currency($info->total - $info->expense)}}
                                            @else
                                            No data
                                            @endif
                                    </span>&nbsp;&nbsp;
                                    <span class="kt-widget25__subtitle">Balance Amount</span>
                                    <div class="kt-widget25__items">
                                        <div class="kt-widget25__item">
                                            <span class="kt-widget25__number text-danger ">
                                            @if(count($budgets)>0)
                                            {{\App\Providers\Common::format_currency($info->expense)}}
                                            @else
                                            No data
                                            @endif
                                            </span>
                                            <span class="kt-widget25__desc">
                                            Spent from budget
                                            </span>
                                        </div>
                                        &nbsp;
                                        <div class="kt-widget25__item">
                                            <span class="kt-widget25__number text-warning ">
                                            @if(count($budgets)>0)
                                            {{\App\Providers\Common::format_currency($info->total)}}
                                            @else
                                            No data
                                            @endif
                                            </span>
                                            <span class="kt-widget25__desc">
                                            Total budget
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>			
                    </div>
                </div>
            </div>
            <div class="col-xl-8">
            <div class="row">
            <div class="col-xl-12">
                <div class="kt-portlet kt-portlet--height-fluid">
                    <div class="kt-portlet__head bg-light">
                        <div class="kt-portlet__head-label">
                            <h3 class="kt-portlet__head-title">
                            Expense vs Budget Graph
                            </h3>
                        </div>
                    </div>
                    <div class="kt-portlet__body">
                        <form class="kt-form kt-form--label-right" name="dep_form" >
                            <div class="row">
                                <div class="form-group col-lg-5">
                                    <select class="form-control kt_select2" id="graph_form_1"  placeholder="Choose Department" name="department_id" >
                                        <option value="0" <?php  if(isset($_GET['department_id'])){  if($_GET['department_id']==0){ echo 'selected="selected"'; }}?> selected="selected" >All dapartments </option>
                                        <?php foreach($category_names as $row){  ?>
                                        <option value="<?php echo $row->id ?>" <?php if(isset($_GET['department_id'])){  if($_GET['department_id']==$row->id){ echo 'selected="selected"'; }}?>>
                                        <?php  echo $row->name ?>
                                        </option>
                                        <?php  }; ?>
                                    </select>
                                </div>
                                <div class="form-group col-lg-5">
                                    <select class="form-control kt_select2" id="graph_form_2" placeholder="Choose Periods" name="periods[]" multiple="multiple">
                                        <?php foreach($periods as $row){  ?>
                                        <option value="<?php  echo $row->id; ?>" <?php  if(isset($requestperiod)){  if(in_array($row->id, $requestperiod)){ echo 'selected="selected"'; }}?>>
                                        <?php  echo $row->name; ?>
                                        </option>
                                        <?php  }; ?>
                                    </select>
                                </div>
                                <div class="col-lg-2">
                                    <input type="hidden" name="_token" value="{!! csrf_token() !!}">
                                    <input class="btn btn-info form-control"  type="submit" name="submit" value="Submit" />
                                </div> 
                            </div>
                        </form>
                        <div class="kt-widget17__item" >	
                            <?php
                                $Array='';
                                foreach($chart_data as $row){
                                    $Array .= "['".$row->name."',".(int)$row->budget.",".(float)$row->expense."],";
                                }
                                $Array = rtrim($Array,',');
                            ?>
                            <?php if($Array==""){?>
                            <div class="col-xl-12">
                                <h4>No data to show.</h4>
                            </div>
                            <?php } ?>
                            <div class="col-xl-12" style="height:225px;">
                                <div id="kt_gchart_1" style="width:100%;"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-12">
                <div class="kt-portlet kt-portlet--height-fluid">
                    <div class="kt-portlet__head bg-light">
                        <div class="kt-portlet__head-label">
                            <h3 class="kt-portlet__head-title">
                            Expense Analysis
                            </h3>
                        </div>
                    </div>
                    <div class="kt-portlet__body">
                        <div class="kt-widget17__item" >	
                            <?php
                                $pieArray='';
                                foreach($chart_data1 as $row){
                                    $pieArray .= "['".$row->name."',".(int)$row->amount."],";
                                }
                                $Array = rtrim($Array,',');
                            ?>
                            <?php if($pieArray==""){?>
                            <div class="col-xl-12">
                                <h4>No data to show.</h4>
                            </div>
                            <?php } ?>
                            <div class="col-xl-12" style="">
                                <div id="kt_gchart_2" style="height:255px;width:100%; "></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>
        </div>
        &nbsp;
        <div class="kt-portlet kt-portlet--mobile">
            <div class="kt-portlet__head kt-portlet__head--lg bg-light">
                <div class="kt-portlet__head-label ">
                    <span class="kt-portlet__head-icon">
                        <i class="kt-font-brand flaticon2-line-chart"></i>
                    </span>
                    <h3 class="kt-portlet__head-title">
                    Pending expenses list for approval
                    </h3>
                </div>
            </div>
            <div class="kt-portlet__body">
                <!--begin: Datatable -->
                <table class="table table-striped- table-bordered table-hover table-checkable" id="pending-expense-table">
                    <thead>
                        <tr>
                            <th>Requests</th>
                            <?php foreach($currency_symbol as $row){ ?>
                            <th ><?php echo $row->symbol; ?></th><?php } ?>
                            <th>Details</th>
                        </tr>
                    </thead>
                    <tbody>
                    <!--     <input type="hidden" name="_token" value="{!! csrf_token() !!}">-->
                        @if(count($expenses)>0)
                        <?php $i=0; ?>
                        @foreach($expenses as $row)
                        @if($row->status=="Pending")
                        <?php
                        $color = "purple";
                        if($row->status=="Pending"){ 
                        $color = "warning"; }?>
                        <tr>
                            <td><h5><a href="{{ URL::asset('/') }}expenses/show/{{$row->id}}">{{$row->item}}</a></h5>
                            <p>From: <span>{{$row->user}}</span> </p>
                            <p>
                            <h5>{{$row->category}}</h5>
                            </p>
                            @if($row->comments != '')
                                <p><strong>Comments: </strong>{{$row->comments}}</p>
                            @endif
                            <div class="" id="comments_box_{{$row->id}}" style="display:none;">
                                <div ><strong>Comments: </strong></div>
                                <textarea name="comments[{{$row->id}}]" id="comments_{{$row->id}}"></textarea>
                            </div></td>
                            <td style="text-align: center;">
                                <p ><span>{{\App\Providers\Common::format_currency($row->price)}}</span> requested</p>
                                <a href="{{ URL::asset('/') }}expenses/show/{{$row->id}}"  class="kt-badge kt-badge--inline kt-badge--pill kt-badge--{{$color}}">{{$row->status}}</span></a></td>
                            <td><p><span>{{\App\Providers\Common::format_currency($row->budget-$row->price)}}</span> Left</p>
                            <p><strong>Priority: </strong>{{$row->priority}}</p></td>
                        </tr>
                        @endif
                        @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
                <?php if($Pending===0)
                    { ?>
                    <h4 align="center">No Pending Request.</h4>
            <?php } ?>  
        </div>
   </div>
</div>
@endsection
@section('pagejs')
<script src="{{URL::asset('')}}assets/vendors/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/select2/dist/js/select2.full.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/chart.js/dist/Chart.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/toastr/build/toastr.min.js" type="text/javascript"></script>
<script src="http://www.google.com/jsapi" type="text/javascript"></script>
<script>
$('#graph_form_1,#graph_form_2').select2({
    placeholder:"Select Periods"
});   
$("#pending-expense-table").DataTable({
	// DOM Layout settings
    dom: `<'row'<'col-sm-6 text-left'l><'col-sm-6 text-right'f>>
  <'row'<'col-sm-12'tr>>
  <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
    lengthMenu: [5, 10, 25, 50],
    pageLength: 10,
    language: {
        'lengthMenu': 'Display _MENU_',
    },
    // Order settings
    order: [[1, 'desc']],
});
var chartData = "<?php  echo $Array; ?>"
if(chartData.length != '')
{
google.load('visualization', '1', {packages: ['corechart', 'bar', 'line']});
google.setOnLoadCallback(drawStuff1);
function drawStuff1() {
    var data = new google.visualization.arrayToDataTable([['Periods', 'Budget', 'Expense'],<?php echo $Array; ?>]);
    var options = {
        title: 'Budget vs Expense Analysis',
        focusTarget: 'category',
        hAxis: {
            title: 'Periods',
        },
        vAxis: {
        },
        colors: ['green', 'red'],
    };
    var chart = new google.visualization.AreaChart(document.getElementById('kt_gchart_1'));
    chart.draw(data, options);
    }
}
var PiechartData = "<?php  echo $pieArray; ?>"
if(PiechartData.length != '')
{
google.load('visualization', '1', {packages: ['corechart']});
google.setOnLoadCallback(drawStuff2);

function drawStuff2() {
    var data = new google.visualization.arrayToDataTable([['Name', 'Amount'],<?php echo $pieArray; ?>]);
    
    var options = {
        title: 'Expense Analysis',
        
        hAxis: {
            title: 'Periods',
        },
        vAxis: {
        },
        
        pieHole: 0.3,
        is3D: true,
        chartArea: {width: 400, height: 300},
        tooltip: { trigger: 'hover' }
    };
    var chart = new google.visualization.PieChart(document.getElementById('kt_gchart_2'));
    chart.draw(data, options);
    }
}
toastr.options = {
"closeButton": true,
"debug": false,
"newestOnTop": false,
"progressBar": false,
"positionClass": "toast-top-center",
"preventDuplicates": false,
"onclick": null,
"showDuration": "300",
"hideDuration": "1000",
"timeOut": "5000",
"extendedTimeOut": "1000",
"showEasing": "swing",
"hideEasing": "linear",
"showMethod": "fadeIn",
"hideMethod": "fadeOut"
};                       
</script>
@if($errors->any())
  @foreach($errors->all() as $error)
   <script>toastr.warning("", "{{$error}}"); </script> 
  @endforeach
@endif
@if(Session::has("message"))
  <script>toastr.success("", "{{ Session::get("message") }}"); </script> 
@endif
@if(Session::has("error"))
  <script> toastr.error("", "{{ Session::get("error") }}"); </script>
@endif
@endsection

