@extends("app")
@section('pagecss')
<link href="{{URL::asset('')}}assets/vendors/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/select2/dist/css/select2.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/css/demo3/style.bundle.css" rel="stylesheet" type="text/css" /> 
<link href="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/sweetalert2/dist/sweetalert2.css" rel="stylesheet" type="text/css" />
@endsection
@section("content")
<div class="row">						
	<div class="col-md-12 ">									
		<div class="kt-portlet kt-portlet--mobile">
			<div class="kt-portlet__head kt-portlet__head--lg bg-light">
				<div class="kt-portlet__head-label">
					<span class="kt-portlet__head-icon">
						<i class="kt-font-brand flaticon2-line-chart"></i>
					</span>
					<h3 class="kt-portlet__head-title">
					Expenses
					</h3>
				</div>
				<div class="kt-portlet__head-toolbar">
					<div class="kt-portlet__head-wrapper">
						<div class="kt-portlet__head-actions">
							<div class="dropdown float-left">
								<button class="btn btn-success dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									Requests
								</button>
								<div class="dropdown-menu" aria-labelledby="dropdownMenuButton" x-placement="top-start" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(0px, -138px, 0px);">
									<a class="dropdown-item" href="{{ URL::asset('/') }}expenses?department={{$department}}&status=all&period={{$period}}&page={{$page}}" >All Expenses</a>
									<a class="dropdown-item" href="{{ URL::asset('/') }}expenses?department={{$department}}&status=Pending&period={{$period}}&page={{$page}}" >Pending</a>
									<a class="dropdown-item" href="{{ URL::asset('/') }}expenses?department={{$department}}&status=Approved&period={{$period}}&page={{$page}}" >Approved</a>
									<a class="dropdown-item" href="{{ URL::asset('/') }}expenses?department={{$department}}&status=Denied&period={{$period}}&page={{$page}}" >Denied</a>
									<a class="dropdown-item" href="{{ URL::asset('/') }}expenses?department={{$department}}&status=Overdue&period={{$period}}&page={{$page}}" >Overdue</a>
									<a class="dropdown-item" href="{{ URL::asset('/') }}expenses?department={{$department}}&status=Closed&period={{$period}}&page={{$page}}" >Closed</a>
								</div>
							</div>&nbsp;
							<select class=" form-control kt-select2" id="department" data-placeholder="Departments" onchange="change_department($(this).val())">
								<option value="all">All Departments</option>
									@if(count($categories)>0)
										@foreach($categories as $row)
											<option value="{{$row->id}}" <?php if($department==$row->id) echo 'selected="selected"'; ?>>{{$row->name}}</option>
										@endforeach
									@endif
							</select>
							<select class=" form-control kt-select2 " id="kt_select2_1" onchange="change_period($(this).val())">
								<option value="all">All Budget Periods</option>
								@if(count($periods)>0)
									@foreach($periods as $row)
										<option value="{{$row->id}}" <?php if($period==$row->id){echo 'selected="selected"';}?>>{{$row->name}}</option>
									@endforeach
								@endif
							</select>
							<button class="btn btn-warning text-white btn-brand btn-elevate"><a onclick="window.location='{{ url('expenses') }}'" >Reset</a></button>
							<button class="btn text-white btn-brand btn-elevate"><a onclick="window.location='{{ url('expenses/create') }}'" ><i class="la la-plus"></i></a></button>	
						</div>
					</div>
				</div>
			</div>
			<div class="kt-portlet__body">
				<form role="form" action="{{ route('expenses_edit') }}" id="" name="" method="post" >
					<input type="hidden" name="_token" value="{!! csrf_token() !!}">
				<table class="table table-striped- table-bordered table-hover table-checkable" id="expense-view-table">
					<thead>
						<tr>
						<th>Period</th>
						<th>Request</th>
						<th>Category</th>
						@foreach($currency_symbol as $row)
							<th>Amount</th>
						@endforeach
						<th>Approver</th>
						<th>Remaining Amount</th>
						</tr>
					</thead>
					<tbody>
					@if(count($expenses)>0)
					@foreach($expenses as $row)
					<?php
						if($row->status=="Pending"){ $color = "warning"; }
						if($row->status=="Approved"){ $color = "success"; }
						if($row->status=="Denied"){ $color = "danger"; }
						if($row->status=="Closed"){ $color = "dark"; }
						if($row->status=="Overdue"){ $color = "info"; }
					?>
					<tr>
						<td><label class="kt-checkbox kt-checkbox--bold"><input type="checkbox"  name="expenses[]" value="{{$row->id}}" class="expenses_checkbox">{{$row->period}}<span></span>&nbsp; <?php if($row->status=="Pending"){?>
							 <a class=" kt-badge kt-badge--md kt-badge--info" href="{{ URL('') }}/expenses/editrequest/{{$row->id}}"><i class="la la-edit"></i></a>
							<?php } ?> </label></td>
						<td style="text-align:left">
							<h5>Item: <a @if(Auth::user()->role!=3) href="{{ URL::asset('/') }}expenses/show/{{$row->id}} @endif" >{{$row->item}}</a></h5>
							<p><h5>Subject: {{$row->subject}}</h5></p> 	
								<p>By: <span>{{$row->user}}</span></p>				   
							@if($row->comments != '')
								<p><strong>Comments: </strong>{{$row->comments}}</p>
							@endif
							<div style="clear:both;height:5px;"></div>
							<div class="" id="comments_box_{{$row->id}}" style="display:none;">
								<div style="float:left;margin-top:8px;"><strong>Comments: </strong></div> <textarea name="comments[{{$row->id}}]" id="comments_{{$row->id}}" style="width:320px;height:42px;margin-left:10px;"></textarea>
							</div></td>
						<td class="category" style="text-align:left"><h5>{{$row->category}}</h5> </td>
						<td class="amount"> 
						<p><span>{{\App\Providers\Common::format_currency($row->price)}}</span> requested</p>
						<a @if(Auth::user()->role!=3)  href="{{ URL::asset('/') }}expenses/show/{{$row->id}}" @endif ><span class="kt-badge kt-badge--inline kt-badge--pill kt-badge--{{$color}}">{{$row->status}}</span></a></td>
						<td class="approvers">
						@if($row->approver!="")
						<div > <?php if($row->approver_logo==""){?> <p align="center"><img src="{{ URL::asset('/') }}uploads/logo.png" width="20px" /></p> 
						<?php } else {?> <p align="center"><img src="{{ URL::asset('/') }}uploads/{{$row->approver_logo}}" width="20px" /></p>
						<?php }?>
							<p>{{$row->approver}}</p>
						</div>
						@endif
						</td>
						<td class="details">
						<p ><span>{{\App\Providers\Common::format_currency($row->budget-$row->price)}}</span> Left</p>
						<p class="priority"><strong>Priority: </strong>{{$row->priority}}</p>	  
						</td>
					</tr>
					@endforeach
					@endif
				</tbody>
			</table>
			@include('expenses.pagination', ['paginator' => $expenses])
				@if(Auth::user()->role!=3)
					<div class="status-trigger">
						<div id="com_warnings" style="color:red;margin-bottom:10px;display:none;">Please fill comment box these are required.</div>
						<div id="acom_warnings" style="color:red;margin-bottom:10px;display:none;">Please Select the Request first.</div>
						<button class="btn btn-danger btn-elevate btn-pill" name="status" id="deniedsubmitbtn" value="Denied" type="submit" style="visibility:hidden;">Deny</button>
						<button class="btn btn-success btn-elevate btn-pill" id="approvestatusbutton" style="visibility:hidden;" name="status" value="Approved" type="submit">Approve</button>
						<button class="btn btn-success btn-elevate btn-pill" id="closestatusbutton" style="visibility:hidden;" name="status" value="Closed" type="submit">Close</button>
					</div>
				@endif
			</form>
			</div>
		</div>
	</div>								
</div>
@stop
@section('pagejs')
<script src="{{URL::asset('')}}assets/vendors/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/select2/dist/js/select2.full.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.min.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/general/sweetalert2/dist/sweetalert2.min.js" type="text/javascript"></script>
<!-- <script src="{{URL::asset('assets/js/custom/expense-request.js')}}"></script> -->
<script>$('#department,#kt_select2_1').select2({
});
$("#expense-view-table").DataTable({
	// DOM Layout settings
	dom: `<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>
  <'row'<'col-sm-12'tr>>`,
  @if(Auth::user()->role!=2)
    buttons: [
        {
            text: 'Deny',
            // value='Denied',
            action: function ( e, dt, node, config ) {
                denyexpenses();
            },
            className: 'btn btn-danger btn-elevate btn-elevate'
        },
        {
            text: 'Approve',
            action: function ( e, dt, node, config ) {
                approve();
            },
            className: 'btn btn-success btn-elevate btn-elevate'
        },
        {
            text: 'Close',
            action: function ( e, dt, node, config ) {
                closeexpenses();
            },
            className: 'btn btn-dark btn-elevate btn-elevate'
        },
    ],
	@endif
    scrollY: false,
    scrollX: true,
    scrollCollapse: true,
    lengthMenu: [5, 10, 20, 40, 80],
    pageLength: 10,
    language: {
      'lengthMenu': 'Display _MENU_',
    }
});
toastr.options = {
  "closeButton": true,
  "debug": false,
  "newestOnTop": false,
  "progressBar": false,
  "positionClass": "toast-top-right",
  "preventDuplicates": false,
  "onclick": null,
  "showDuration": "300",
  "hideDuration": "1000",
  "timeOut": "5000",
  "extendedTimeOut": "1000",
  "showEasing": "swing",
  "hideEasing": "linear",
  "showMethod": "fadeIn",
  "hideMethod": "fadeOut"
};
function change_department(id){
	var url = '{{ URL::asset('/') }}expenses?department='+id+'&status={{$status}}&period={{$period}}&page{{$page}}';
	window.location = url;
}
function change_period(id){
	var url = '{{ URL::asset('/') }}expenses?department={{$department}}&status={{$status}}&period='+id+'&page{{$page}}';
	
	window.location = url;
}
function denyexpenses(){
	$(".expenses_checkbox").each(function(index, element) {
		var checking = $(this).is(':checked');
		var checkboxid = $(this).val();
		if(checking === true){ 
			window.scrollTo(0,200); 
			$("#comments_box_"+checkboxid).slideDown('slow');
			$("#comments_"+checkboxid).addClass('validatecommentbox'); 
		}else{
			$("#comments_box_"+checkboxid).slideUp('slow');
			$("#comments_"+checkboxid).removeClass('validatecommentbox');
		}
	});
	var commentcounter = 0;
	$(".expenses_checkbox").each(function(index, element) {
		var checking = $(this).is(':checked'); 
		if(checking === true){ 
			commentcounter++; 
		}
	});
	var allemptycommentbox=$(".validatecommentbox").filter(function() {
		return this.value;
	}); 
	if(commentcounter == 0){
		$("#acom_warnings").show();
		toastr.warning( "Please Select the Request first.");
	}else if(allemptycommentbox.length == 0 ){
		$("#com_warnings").show();
		toastr.warning( "Please fill comment box these are required.");
	}else if(allemptycommentbox.length == commentcounter){
		$("#com_warnings").hide();	
		$("#deniedsubmitbtn").trigger('click');
	}
}
function closeexpenses(){
	var commentcounter = 0;
	$(".expenses_checkbox").each(function(index, element) {
		var checking = $(this).is(':checked'); 
		if(checking === true){ 
			commentcounter++; 
		}
	});
	if(commentcounter>0){
		swal.fire({
		title: 'Are you sure?',
		type: 'info',
		showCancelButton: true,
		confirmButtonText: 'Yes',
		cancelButtonText: 'No, cancel!',
		reverseButtons: true
	}).then(function(result){
		if (result.value) {
				$("#closestatusbutton").trigger('click');	
		}
		});
	}
	else {
		$("#acom_warnings").show();
		toastr.warning( "Please Select the Request first.");

			}
	}	
function approve(){
	
	var commentcounter = 0;
	$(".expenses_checkbox").each(function(index, element) {
		var checking = $(this).is(':checked'); 
			if(checking === true){	
				commentcounter++; 
			}
	});
	if(commentcounter>0){
		swal.fire({
		title: 'Are you sure?',
		type: 'info',
		showCancelButton: true,
		confirmButtonText: 'Yes',
		cancelButtonText: 'No, cancel!',
		reverseButtons: true
	}).then(function(result){
		if (result.value == true) {
			
			$("#approvestatusbutton").trigger('click');	
			
		}
	});	 	
	}
	else{
		$("#acom_warnings").show();
		toastr.warning( "Please Select the Request first.");
	}
}	
function changestatussingle(expenseid){
	var commentbox = $("#comment_single_"+expenseid).val();
	var newstatus = $("#expense_status_"+expenseid).val();
	if(newstatus == 'Denied'){
	if(commentbox == ''){
		$("#comments_single_tr_id").slideDown('slow');
	}else{ 
		commentbox = $("#comment_single_"+expenseid).val();
		$.post( "{{ URL::asset('/') }}expenses/updatestatus", {newstatus:newstatus,commentbox:commentbox,expenseid:expenseid,_token:'{!! csrf_token() !!}'}).done(function(data){
			location.reload();
		});
	}
	}else{
		$.post( "{{ URL::asset('/') }}expenses/updatestatus", {newstatus:newstatus,commentbox:commentbox,expenseid:expenseid,_token:'{!! csrf_token() !!}'}).done(function(data){
			location.reload();
		});
	}
}
</script>
@if($errors->any())
  @foreach($errors->all() as $error)
   <script>toastr.warning("Sorry", "{{$error}}"); </script> 
  @endforeach
@endif
@if(Session::has("message"))
  <script>toastr.success("", "{{ Session::get("message") }}"); </script> 
@endif
@if(Session::has("error"))
  <script> toastr.error("", "{{ Session::get("error") }}"); </script>
@endif
@endsection