@extends("app")
@section('pagecss')
<link href="{{URL::asset('')}}/assets/vendors/general/bootstrap-datepicker/dist/css/bootstrap-datepicker3.css" rel="stylesheet" type="text/css" />
@endsection
@section("content")
<div class="row">
  <div class="col-lg-12">
    <div class="kt-portlet">
      <div class="kt-portlet__head bg-light">
        <div class="kt-portlet__head-label ">
          <h3 class="kt-portlet__head-title">
          {{$title}}
          </h3>
        </div>
        <div class="kt-portlet__head-toolbar">
          <div class="kt-portlet__head-wrapper">
            <div disabled style="height:40px;" class="kt-badge kt-badge--warning kt-badge--inline kt-badge--pill kt-badge--xl " style="font-size:17px;">
            Budget Limit = {{ \App\Providers\Common::currency_symbol()}}  &nbsp;<div id="budget-limit"></div></div>
          </div>&nbsp;
          <div class="kt-portlet__head-wrapper">
            <a href="<?php echo $_SERVER['HTTP_REFERER'] ?>" class="btn btn-primary text-white btn-icon-sm">
            <i class="la la-long-arrow-left"></i>Back</a>
          </div>
        </div>
      </div>
      <form class="kt-form kt-form--label-right" role="form" name="formexpense" id="formexpense"  action="{{ url('') }}/expenses/request_update/{{$expense->id}}" method="post" id="expneses" enctype="multipart/form-data">
        <div class="kt-portlet__body">
          <input type="hidden" name="_token" value="{!! csrf_token() !!}">
          <input type="hidden" value="{{$expense->company_id}}" name="company_id" />
          <input type="hidden" value="{{$expense->outside}}" class="form-control" name="outside" id="outside">
          <div id="budget-limit"></div>
          <div class="form-group row">
            <div class="col-lg-12">
              <div class="row">
              <div class="form-group col-lg-4">
                <label for="subject">Expense Date</label>
                  <input type="text" class="form-control " name="expense_date" value="{{$expense->expense_date}}" id="expense_date" />
              </div>
            <div class="form-group col-lg-4">
              <label for="subject" >Period</label> 
                <select class="form-control" name="period_id" onchange="change_period($(this).val())">
                  <option value="all">Choose Budget Period</option>
                  @if(count($periods)>0)
                  @foreach($periods as $row)
                  <option value="{{$row->id}}" <?php if($expense->period_id==$row->id){echo 'selected="selected"';}?>>{{ $row->name }}</option>
                  @endforeach
                  @endif
                </select>
            </div>
            <div class="form-group col-lg-4" id="result">
                <label for='deparment' class='label-control'>Item</label>
                <select class='form-control' name='budget_id' id='budget_id'><option id='result' value="{{$expense->budget_id}}">{{$expense_item->item}}</option></select>
            </div>
            <div class=" form-group col-lg-4">
              <label for="priority">Priority</label>
                <select class="form-control " name="priority" id="priority">
                  <option value="">Choose Priority</option>
                  <option value="High" <?php if($expense->priority=="High"){ echo 'selected="selected"'; } ?> >High</option>
                  <option value="Medium" <?php if($expense->priority=="Medium"){ echo 'selected="selected"'; } ?>>Medium</option>
                  <option value="Low" <?php if($expense->priority=="Low"){ echo 'selected="selected"'; } ?>>Low</option>
                </select>
            </div>
            <div class=" form-group col-lg-4">
              <label for="price" class="">Expense Amount ({{ \App\Providers\Common::currency_symbol()}})</label>
                <input type="text" value="{{$expense->price}}" class="form-control " name="price" id="price">
                <p class="red text-danger" id="out_of_budget" style="display:none;">Sorry! Your amount is out of the item budget.</p>
            </div>
            <div class="form-group col-lg-4">
              <label for="subject" class="">Subject</label>
                <input type="text" value="{{$expense->subject}}" class="form-control" name="subject" id="subject">
            </div>
            <div class="col-lg-4">
              <label>Picture</label>
              <div class="custom-file " >
                <input type="file" value="" class="custom-file-input" name="file" id="file"/>
                <label class="custom-file-label" style="text-align:left;" for="file">{{$expense->file}}</label>
              </div>
            </div>        
            <div class="form-group col-lg-4">
							<label for="description">Description</label>
							<textarea class="form-control" value="{{$expense->description}}" name="description" id="editor" rows="5">{{$expense->description}}</textarea>
							</div>
              </div>	
          </div>
        </div>
      </div>
        <div class="kt-portlet__foot">
          <div class="kt-form__actions">
            <div class="row">
              <div class="col-lg-5"></div>
              <div class="col-lg-6">
                <button type="submit" id="submit" class="btn btn-primary">Update</button>
                <button type="reset" class="btn btn-secondary">Clear</button>
              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
</div>
@stop
@section('pagejs')
<script src="{{URL::asset('')}}assets/vendors/general/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/jquery.validate.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/additional-methods.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/custom/js/vendors/jquery-validation.init.js" type="text/javascript"></script>
<!-- <script src="{{URL::asset('assets/js/custom/expense-create.js')}}"></script> -->
<script>
$("#expense_date").datepicker({  
    rtl: KTUtil.isRTL(),
    todayHighlight: true,
    orientation: "bottom left",
    format:'dd/mm/yyyy',
});
$( document ).ready(function() {
  $.post("{{url::asset('/')}}expenses/get_budget",{val:{{$expense->budget_id}}, _token:"{!! csrf_token() !!}"}).done(function(data){
  $("#price").attr("placeholder", "Budget limit: {{ \App\Providers\Common::currency_symbol()}} "+data);
  $('#budget-limit').empty(data);
  $('#budget-limit').append(data);
       
	});  
});

function get_budget_balance(val){		
  $.post("{{url::asset('/')}}expenses/get_budget",{val:val, _token:"{!! csrf_token() !!}"}).done(function(data){
  $("#price").attr("placeholder", "Budget limit: {{ \App\Providers\Common::currency_symbol()}} "+data);
  $('#budget-limit').empty(data);
  $('#budget-limit').append(data);
  $("#outside").val(data);
  $("#price").keyup(function(e){
    var budget =data;
    var price = $(this).val();
    price = parseInt(price);
    if(price>budget){
      $("#submit").attr("disabled", true); 
      $("#expneses").attr("onsubmit", "return false");
      $("#price").addClass("red");
      $("#out_of_budget").show();
    }else{
      $("#submit").attr("disabled", false);
      $("#expneses").removeAttr("onsubmit");
      $("#price").removeClass("red");
      $("#out_of_budget").hide();
    }
    });     
	});		  
}
$(document).ready(function(e) {
	$("#price").keyup(function(e) {
		var value = $("#budget_id").val()
		//val = val.split(':');
		//var budget = parseInt(val[1]);
			//  var budget =get_budget_balance();
			$.post("{{url::asset('/')}}expenses/get_value",{value:value, _token:"{!! csrf_token() !!}"}).done(function(data){
			var budget = data;
		var price = $(this).val();
		price = parseInt(price);
		if(price>budget){
    $("#submit").attr("disabled", true); 
		$("#expneses").attr("onsubmit", "return false");
		$("#price").addClass("red");
		$("#out_of_budget").show();
		}else{
    $("#submit").attr("disabled", false);
		$("#expneses").removeAttr("onsubmit");
		$("#price").removeClass("red");
		$("#out_of_budget").hide();
		}
		});
	});
});
$( "#formexpense" ).validate({
  rules: {
    expense_date: {
              required: true 
          }, 
      period_id: {
          required: true 
      },
      period_id: {
          required: true,
      },
      priority: {
          required: true,
      },
      price: {
          required: true,
      },
      subject: {
          required: true
      },
      description: {
          required: true
      }
  },
  //display error alert on form submit  
  invalidHandler: function(event, validator) {     
  },

  submitHandler: function (form) {
      form[0].submit(); // submit the form
  }
});
function change_period(vals){		
$.post("{{url::asset('/')}}expenses/get_period",{vals:vals, _token:"{!! csrf_token() !!}"}).done(function(data){
	//alert(data);
	$("#result").html(data);
	//return data;
});
}
</script>
@endsection
