@extends("app")
@section('pagecss')
<link href="{{URL::asset('')}}assets/vendors/general/select2/dist/css/select2.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/css/demo3/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section("content")
<div class="row">
  <div class="col-md-12">
	  <div class="kt-portlet kt-portlet--mobile">
		  <div class="kt-portlet__head kt-portlet__head--lg bg-light">
			  <div class="kt-portlet__head-label">
				<span class="kt-portlet__head-icon">
					<i class="kt-font-brand flaticon2-line-chart"></i>
				</span>
				<h3 class="kt-portlet__head-title">
				Item Expense detail
					<small></small>
				</h3>
			</div>
			<div class="kt-portlet__head-toolbar">
				<div class="kt-portlet__head-wrapper">
        <select id="expense_status_<?php echo $row->id;?>" name="" class="form-control kt-select_2">
            <option <?php if($row->status == 'Approved'){echo 'selected="selected"';} ?> value="Approved">Approved</option>
            <option <?php if($row->status == 'Closed'){echo 'selected="selected"';} ?> value="Closed">Closed</option>
            <option <?php if($row->status == 'Denied'){echo 'selected="selected"';} ?> value="Denied">Denied</option>
            <option <?php if($row->status == 'Overdue'){echo 'selected="selected"';} ?> value="Overdue">Overdue</option>   
          </select>
          &nbsp;
          <button type="button" @if(Auth::User()->role=='2') disabled @endif onclick="changestatussingle(<?php echo $row->id; ?>)" class="btn btn-success" >Update</button>
          &nbsp;
          <a href="<?php echo $_SERVER['HTTP_REFERER'] ?>" class="btn btn-primary text-white btn-icon-sm">
          <i class="la la-long-arrow-left"></i>Back</a>
				</div>
			</div>
		</div>
		<div class="kt-portlet__body">

			<!--begin: Datatable -->
			<table class="table table-striped- table-bordered table-hover table-checkable" id="item-expense-table">
      <tr>
    <th>ID:</th>
    <td>{{$row->id}}</td>
  </tr>
  <tr>
    <th>Item: </th>
    <td>{{$row->item}}</td>
  </tr>
  <tr>
    <th>From: </th>
    <td>{{$row->user}}</td>
  </tr>
  <?php
    $color = "purple";
      if($row->status=="Pending"){ $color = "warning"; }
      if($row->status=="Approved"){ $color = "success"; }
      if($row->status=="Denied"){ $color = "danger"; }
      if($row->status=="Closed"){ $color = "dark"; }
      if($row->status=="Overdue"){ $color = "info"; }
  ?>
  <tr>
    <th>Status: </th>
    <td>
    	<span class="kt-badge kt-badge--inline kt-badge--pill kt-badge--{{$color}}">{{$row->status}}</span>
    </td>
  </tr>
  <tr>
    <th>Budget: </th>
    <td>{{\App\Providers\Common::format_currency($row->budget)}}</td>
  </tr>
  <tr>
    <th>Priority: </th>
    <td>{{$row->priority}}</td>
  </tr>
  <tr>
    <th>Requested: </th>
    <td>{{\App\Providers\Common::format_currency($row->price)}}</td>
  </tr>
  <tr>
    <th>Left: </th>
    <td>{{\App\Providers\Common::format_currency($row->budget-$row->price)}}</td>
  </tr>
  <tr>
    <th>Department: </th>
    <td>{{$row->category}}</td>
  </tr>
  <tr>
    <th>Subject: </th>
    <td>{{$row->subject}}</td>
  </tr>
  <tr>
    <th>Description: </th>
    <td><div style="width:500px;"><?php echo $row->description; ?></div></td>
  </tr>
  <tr>
    <th>Approver: </th>
	<?php if($row->approver_logo==""){?>
    <td><img src="{{ URL::asset('/') }}uploads/logo.png" alt="{{$row->approver_logo}}" width="20px" /> {{$row->approver}}</td>
	<?php } else { ?>
	<td><img src="{{ URL::asset('/') }}uploads/{{$row->approver_logo}}" alt="{{$row->approver_logo}}" width="20px" /> {{$row->approver}}</td>
	<?php }?>
  </tr>
  <tr>
    <th>Period: </th>
    <td>{{$row->period}}</td>
  </tr>
  <tr>
    <th>Expense date: </th>
    <td>{{\App\Providers\Common::format_date($row->expense_date)}}</td>
  </tr>
 <tr>
    <th>File: </th>
    <?php if ($row->file==""){?>
    <td><img src="{{ URL::asset('/') }}uploads/no_file_available.png" alt="no_file_available.png" width="200px" /></td>
    <?php } else {?> <td><img src="{{ URL::asset('/') }}/uploads/{{$row->file}}" alt="{{$row->file}}" width="200px" /></td> <?php }?>
  </tr>
  <tr id="comments_single_tr_id" style="display:none;">
    <th>Comments: <span style="color:red;">Required</span></th>
    <td>
    <textarea name="" id="comment_single_<?php echo $row->id; ?>" style="width:100%;"><?php echo $row->comments; ?></textarea>
    </td>
  </tr>
  @if($row->comments !='')
  <tr>
    <th>Comments: </th>
    <td>{{$row->comments}}</td>
  </tr>
  @endif
			</table>
			<!--end: Datatable -->
		</div>
	</div>
  </div>
</div>



@stop
@section('pagejs')
<script src="{{URL::asset('')}}assets/vendors/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/select2/dist/js/select2.full.js" type="text/javascript"></script>
<!-- <script src="{{URL::asset('assets/js/custom/expense-detail.js')}}"></script> -->
<script>
$('.kt-select_2').select2();

function change_budget(val){
	val = val.split(':');
	var budget = parseInt(val[1]);
	$("#price").attr("placeholder", "Budget limit: "+budget);
	$("#price").attr("max", budget);
	$("#outside").val(budget);
}
$(document).ready(function(e) {
	$("#price").keyup(function(e) {
		var val = $("#budget_id").val()
		val = val.split(':');
		var budget = parseInt(val[1]);
		var price = $(this).val();
		price = parseInt(price);
		if(price>budget){
			$("#expneses").attr("onsubmit", "return false");
			$("#price").addClass("red");
			$("#out_of_budget").show();
		}else{
			$("#expneses").removeAttr("onsubmit");
			$("#price").removeClass("red");
			$("#out_of_budget").hide();
		}
	});
});
	function changestatussingle(expenseid){
	var commentbox = $("#comment_single_"+expenseid).val();
	var newstatus = $("#expense_status_"+expenseid).val();
	if(newstatus == 'Denied'){
	if(commentbox == ''){
		$("#comments_single_tr_id").slideDown('slow');
	}else{ 
		commentbox = $("#comment_single_"+expenseid).val();
		$.post( "{{ URL::asset('/') }}expenses/updatestatus", {newstatus:newstatus,commentbox:commentbox,expenseid:expenseid,_token:'{!! csrf_token() !!}'}).done(function(data){
			location.reload();
		});
	}
	}else{
		$.post( "{{ URL::asset('/') }}expenses/updatestatus", {newstatus:newstatus,commentbox:commentbox,expenseid:expenseid,_token:'{!! csrf_token() !!}'}).done(function(data){
			location.reload();
		});
	}
};

///flag
</script>
@endsection