@extends('app')
@section('pagecss')
<link href="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/sweetalert2/dist/sweetalert2.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/css/custom/company-index.css" rel="stylesheet" type="text/css" />
@endsection
@section('content')
<div class="row"  >
 <div class="col-md-12" >
    <div class="kt-portlet">
        <div class="kt-portlet__head">
            <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon kt-hide">
                    <i class="la la-gear"></i>
                </span>
                <h3 class="kt-portlet__head-title">
                <button  onclick="window.location='{{ url('companies/create') }}'" @if(Auth::user()->role==2) disabled @endif class="btn btn-success">Add New Company</button>
                </h3>
            </div>
        </div>
    </div>
    <div class="row" >
    <?php if(count($companies)>0): ?>
        <?php $i=0; ?>
        <?php foreach($companies as $row): ?>
        <?php
        if(Auth::user()->role==1 || $users->exists(Auth::user()->id, $row->id)):
        $display = (Auth::user()->company_id==$row->id ? "display:none;" : "display:block;");
        $active = (Auth::user()->company_id==$row->id ? "true" : "false");?>
        <div class="col-md-4">
            <div class="kt-portlet kt-portlet--height-fluid logo-image">
                <div class="kt-portlet__head  kt-portlet__head--noborder">
                    <div class="kt-portlet__head-label">
                        &nbsp;
                    </div>
                </div>
                <div class="kt-portlet__body kt-portlet__body--fit-y">
                    <!--begin::Widget -->
                    <div class="kt-widget kt-widget--user-profile-1">
                        <div class="kt-widget__head">
                            <div class="kt-widget__media company-image">
                                <img src="{{ URL::asset('/')}}uploads/{{$row->logo}}" alt="image">
                            </div>
                            <div class="kt-widget__content">
                                <div class="kt-widget__section">
                                    <a href="#" class="kt-widget__username">
                                    {{$row->name}} 
                                        <?php if($active=="true"){?> <i class="flaticon2-correct kt-font-success"></i> <?php } ?> 
                                    </a>
                                    <span class="kt-widget__subtitle">
                                    <?php $currency=Auth::user()->curr_name();
                                        { foreach($currency as $curr){
                                            if($curr->id == $row->currencies){
                                                echo $curr->currency_name; echo " ("; echo $curr->symbol; echo ")";
                                        }}}?>
                                    </span>
                                </div>
                                <div class="kt-widget__action">
                                    @if(Auth::user()->role==1)
                                        <a type="button"  href="{{url('companies/edit',$row->id)}}" class="btn btn-info btn-sm">Edit</a>&nbsp;
                                    @endif
                                    <?php if($active=="false"){?> <a type="button" href="{{ url('companies/active/?company='.urlencode(base64_encode($row->id))) }}" class="btn btn-success btn-sm">Log In</a> <?php } ?>
                                </div>
                            </div>
                        </div>  
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php endforeach; ?>
        <?php endif; ?>
    </div>
 </div>
</div>
@endsection
@section('pagejs')
<script src="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.min.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/general/sweetalert2/dist/sweetalert2.min.js" type="text/javascript"></script>
<script>
toastr.options = {
  "closeButton": true,
  "debug": false,
  "newestOnTop": false,
  "progressBar": false,
  "positionClass": "toast-top-right",
  "preventDuplicates": false,
  "onclick": null,
  "showDuration": "300",
  "hideDuration": "1000",
  "timeOut": "5000",
  "extendedTimeOut": "1000",
  "showEasing": "swing",
  "hideEasing": "linear",
  "showMethod": "fadeIn",
  "hideMethod": "fadeOut"
};

</script>
@if(Session::has("message"))
	<script>toastr.success("", "{{ Session::get("message") }}"); </script> 
@endif
@if(Session::has("error"))
<script> toastr.error("", "{{ Session::get("error") }}"); </script>
@endif
@endsection