@extends("app")
@section("pagecss")
<link href="{{URL::asset('')}}assets/vendors/general/select2/dist/css/select2.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/css/demo3/style.bundle.css" rel="stylesheet" type="text/css" />  
@endsection

@section("content")
<div class="row">
  <div class="col-lg-12">
    <div class="kt-portlet">
      <div class="kt-portlet__head bg-light">
        <div class="kt-portlet__head-label">
          <h3 class="kt-portlet__head-title">
          {{$title}}
          </h3>
        </div>
        <div class="kt-portlet__head-toolbar">
				  <div class="kt-portlet__head-wrapper">
								<a href="<?php echo $_SERVER['HTTP_REFERER'] ?>" class="btn btn-primary text-white btn-icon-sm">
							<i class="la la-long-arrow-left"></i>Back</a>
          </div>
        </div>
      </div>
      <form class="kt-form kt-form--label-right" role="form"  id="company_form" action="{{ url('companies/store') }}" enctype="multipart/form-data" method="post">
      <div class="row">
        <div class="form-group col-lg-6">
          <div class="kt-portlet__body">
          <input type="hidden" name="_token" value="{!! csrf_token() !!}">
          <div class="form-group kt-row ">
            <label for="item" class="">Name</label>
            <input type="text" value="{{old('name')}}" class="form-control" name="name" placeholder="Enter company name">
          </div>
          <div class="row">
            <div class=" form-group col-lg-8">
              <label for="periods" class="">Currency</label>
              <select class="form-control " id="currency" name="currency" onchange="get_symbol($(this).val())">
                <option value="">Choose Currency</option>
                @if(count($currency)>0)
                  @foreach($currency as $row) 
                  <option value="{{$row->id}}">{{$row->country}} - {{$row->currency_name}}</option>
                  @endforeach
                @endif
                </select>          
              </div>
              <div class="form group col-lg-4">
                <div class=" form-group" id="currency_symbol">
                </div>
            </div>
            <div class="form-group col-lg-12">
              <label>Logo</label>
                <div class="custom-file" >
                  <input type="file" class="custom-file-input browse" name="logo" id="customFile"/>
                  <label class="custom-file-label" style="text-align:left;" for="customFile"></label>
                </div>
              </div>
            </div>
          </div>
        </div>
          <div class="col-lg-6">
            <div class="row" >
              <label class="col-lg-12 col-form-label text-center">Logo</label>
              <div class="col-lg-12 text-center">
                <div class="kt-avatar kt-avatar--outline kt-avatar--circle" id="kt_apps_user_add_avatar">
                <img src="{{ URL::asset('') }}uploads/logo.png" class="kt-avatar__holder img-fluid lightBoxGallery " id="preview" alt="pic">
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="kt-portlet__foot">
          <div class="kt-form__actions">
            <div class="row">
              <div class="col-lg-5"></div>
              <div class="col-lg-6">
                <button type="submit" class="btn btn-primary">Submit</button>
                <button type="reset" class="btn btn-secondary">Clear</button>
              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
@section("pagejs")
<script src="{{URL::asset('/')}}assets/vendors/general/select2/dist/js/select2.full.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/js/scripts.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/jquery.validate.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/additional-methods.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/custom/js/vendors/jquery-validation.init.js" type="text/javascript"></script>
<script>
$('#currency').select2({
    placeholder: "Select currency"
});	

 function get_symbol(vals){
			
			  //  alert('test 1');

				 /* , _token:'<?php echo csrf_token(); ?>' */
                    
				$.get("{{route('symbol_values')}}" , {value:vals, _token:'<?php echo csrf_token(); ?>'}).done(function(data){
				
				// alert(data);
				 $("#currency_symbol").html(data);
});
}
$(document).on("click", ".browse", function() {
    var file = $(this).parents().find(".file");
    file.trigger("click");
  });
$('input[type="file"]').change(function(e) {
  var fileName = e.target.files[0].name;
  $("#file").val(fileName);

  var reader = new FileReader();
  reader.onload = function(e) {
    // get loaded data and render thumbnail.
    document.getElementById("preview").src = e.target.result;
  };
  // read the image file as a data URL.
  reader.readAsDataURL(this.files[0]);
});

$( "#company_form" ).validate({
  // define validation rules
  rules: {
      name:{
        required:true,
      },
      logo: {
          required: true,
      },
      currency: {
          required: true,
      }
     
  },
  //display error alert on form submit  
  invalidHandler: function(event, validator) {     

  },

  submitHandler: function (form) {
      form[0].submit(); // submit the form
  }
});
</script>
	
@endsection

@stop