@extends("app")

@section("pagecss")
<link href="{{URL::asset('')}}assets/vendors/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/select2/dist/css/select2.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/css/demo3/style.bundle.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/sweetalert2/dist/sweetalert2.css" rel="stylesheet" type="text/css" />
@endsection
@section("content")
<?php //echo "<pre>"; print_r(Auth::user());exit; ?>
<div class="row">
  <div class="col-md-12">
    <div class="kt-portlet">
      <div class="kt-portlet__body  kt-portlet__body--fit">
        <div class="row row-no-padding row-col-separator-xl">
          <div class="col-md-12 col-lg-6 col-xl-3">
            <div class="kt-widget24">
            <h4 class="kt-widget24__title">&nbsp;</h4>
              <div class="kt-widget24__details">
                <div class="kt-widget24__info">
                  <h4>
                  Budget Information:
                  @if(count($periods)>0)
                    @foreach($periods as $row)
                      @if($period==$row->id)
                        {{$row->name}}
                      @endif
                    @endforeach
                  @endif
                </h4>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-12 col-lg-6 col-xl-3">
          <div class="kt-widget24">
            <h4 class="kt-widget24__title">&nbsp;</h4>
            <div class="kt-widget24__details">
              <div class="kt-widget24__info">
                <h4 class="kt-widget24__title">
                Total budget:
                </h4>
              </div>
              <h4 class="kt-widget22__stats kt-font-warning">
              @if(count($budgets)>0)
              {{\App\Providers\Common::format_currency($info->total)}}
              @else
              No data
              @endif
              </h4>
            </div>
            <h4 class="kt-widget24__title">&nbsp;</h4>
          </div>
        </div>
        <div class="col-md-12 col-lg-6 col-xl-3">
          <div class="kt-widget24">
          <h4 class="kt-widget24__title">&nbsp;</h4>
            <div class="kt-widget24__details">
              <div class="kt-widget24__info">
                <h4 class="kt-widget24__title">
                Spent from budget:
                </h4>
              </div>
              <h4 class="kt-widget22__stats kt-font-danger">
              @if(count($budgets)>0)
              {{\App\Providers\Common::format_currency($info->expense)}}
              @else
              No data
              @endif
              </h4>
            </div>
            <h4 class="kt-widget24__title">&nbsp;</h4>
          </div>
        </div>
        <div class="col-md-12 col-lg-6 col-xl-3">
          <div class="kt-widget24">
            <h4 class="kt-widget24__title">&nbsp;</h4>
              <div class="kt-widget24__details">
                <div class="kt-widget24__info">
                  <h4 class="kt-widget24__title">
                  Balance Amount: 
                  </h4>
                </div>
                <h4 class="kt-widget22__stats kt-font-success">
                @if(count($budgets)>0)
                {{\App\Providers\Common::format_currency($info->total-$info->expense)}}
                @else
                No data
                @endif
                </h4>
              </div>
              <h4 class="kt-widget24__title">&nbsp;</h4>
            </div>
          </div>
        </div>
      </div>
    </div>           
    <div class="kt-portlet">           
      <div class="kt-portlet__head kt-portlet__head--lg">
        <div class="kt-portlet__head-label">
          <div class="dropdown">
            <button class="btn-success form-control dropdown dropdown-inline" type="button"  id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="width: 100px;">
              Filters 
            </button>
            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton" x-placement="top-start" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(0px, -138px, 0px);">
              <a class="dropdown-item" href="{{ URL::asset('/') }}budgets">All </a>
              <?php if(count($categories)>0): ?>
              <?php $i=0; ?>
              <?php foreach($categories as $row): ?>
              <a class="dropdown-item" href="{{ URL::asset('/') }}budgets?department={{$row->id}}&period={{$period}}" >{{$row->name}} ({{\App\Providers\Common::format_currency($row->from)}}/{{\App\Providers\Common::format_currency($row->total)}} spent ) </a>
              <?php endforeach; ?>
              <?php endif; ?>	
            </div>
          </div>
        </div>
        <div class="kt-portlet__head-toolbar">
          <div class="kt-portlet__head-wrapper">
            <div class="kt-portlet__head-actions">
              <select class="form-control kt-select_2"  id="select_budget_period" onchange="change_period($(this).val())">
                <option value="all">All Periods</option>
                @if(count($periods)>0)
                  @foreach($periods as $row)
                    <option value="{{$row->id}}" <?php if($period==$row->id){echo 'selected="selected"';}    /* {{\App\Providers\Common::format_date($row->from)}} to {{\App\Providers\Common::format_date($row->to)}}*/ ?>>{{$row->name}}</option>
                  @endforeach
                @endif
              </select>
            </div>
            &nbsp;
            <a onclick="window.location='{{ url('budgets/create') }}'" class="btn text-white btn-brand btn-elevate btn-icon-sm">
              <i class="la la-plus"></i>
              Add New Budget
            </a>
          </div>
        </div>
      </div>  
      <div class="kt-portlet kt-portlet--mobile">     
        <div class="kt-portlet__body">
          <table class="table table-striped- table-bordered table-hover table-checkable" id="budget-view-table">
            <thead>
              <tr>
                <th>Period</th>
                <th >Category</th>
                <th >Item</th>
                <th> Unit ({{ \App\Providers\Common::currency_symbol()}}) </th>
                <th>Quantity</th>
                <th>Budget ({{ \App\Providers\Common::currency_symbol()}})</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
            @if(count($budgets)>0)
            @foreach($budgets as $row)
              <tr>
                <td class="">{{$row->period}}</td>
                <td class="" style="text-align:left">{{$row->category}}</td>
                <td class="requests" style="text-align:left">{{$row->item}}</td>
                <td class="amount" style="text-align:right"><p>{{\App\Providers\Common::format_currency($row->unit)}}</p></td>
                <td class="approvers" style="text-align:right">{{$row->quantity}}</td>
                <td class="details" style="text-align:right"><p>{{\App\Providers\Common::format_currency($row->budget)}}</p></td>
                <td><a class=" kt-badge kt-badge--lg kt-badge--info" href="{{url('budgets/edit',$row->id)}}" ><i class="la la-edit" id="btn"  ></i></a>	&nbsp;   <a class=" kt-badge kt-badge--lg kt-badge--danger" href="{{ url('budgets/delete/'.$row->id)}}" onclick="budget_delete(event)"><i class="la la-trash"></i></a></td>
              </tr>
                @endforeach
                @endif
            </tbody> 
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
@section("pagejs")
<script src="{{URL::asset('')}}assets/vendors/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/select2/dist/js/select2.full.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.min.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/general/sweetalert2/dist/sweetalert2.min.js" type="text/javascript"></script>
<!-- <script src="{{URL::asset('assets/js/custom/budget.js')}}"></script> -->
<script>
$('#select_budget_period').select2();
$("#budget-view-table").DataTable({
  // DOM Layout settings
  dom: `<'row'<'col-sm-6 text-left'l><'col-sm-6 text-right'f>>
  <'row'<'col-sm-12'tr>>
  <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
    
    scrollY: false,
    scrollX: true,
    scrollCollapse: true,

    lengthMenu: [5, 10, 25, 50,],

    pageLength: 10,

    language: {
      'lengthMenu': 'Display _MENU_',
    },

    // Order settings
    order: [[1, 'desc']],
});
	function change_period(id){
		var url = '{{ URL::asset('/') }}budgets?department={{$department}}&period='+id;
		window.location = url;
	}
toastr.options = {
  "closeButton": true,
  "debug": false,
  "newestOnTop": false,
  "progressBar": false,
  "positionClass": "toast-top-right",
  "preventDuplicates": false,
  "onclick": null,
  "showDuration": "300",
  "hideDuration": "1000",
  "timeOut": "5000",
  "extendedTimeOut": "1000",
  "showEasing": "swing",
  "hideEasing": "linear",
  "showMethod": "fadeIn",
  "hideMethod": "fadeOut"
};
function budget_delete(e){
e.preventDefault();
var urlToRedirect = e.currentTarget.getAttribute('href');
{	
	swal.fire({
		title: 'Are you sure?',
		text: "You won't be able to revert this!",
		type: 'error',
		showCancelButton: true,
		confirmButtonText: 'Yes, delete it!',
		cancelButtonText: 'No, cancel!',
		reverseButtons: true
	}).then(function(result){
		if(result.value){
			window.location.href= urlToRedirect ;	
		}
    else if (result.dismiss === 'cancel') {
		}
	});
}}
</script>
@if($errors->any())
  @foreach($errors->all() as $error)
   <script>toastr.warning("", "{{$error}}"); </script> 
  @endforeach
@endif
@if(Session::has("message"))
  <script>toastr.success("", "{{ Session::get("message") }}"); </script> 
@endif
@if(Session::has("error"))
  <script> toastr.error("", "{{ Session::get("error") }}"); </script>
@endif
@stop
@stop