@extends("app")

@section("pagecss")
@endsection
@section("content")
<div class="row">
  <div class="col-lg-12">
    <div class="kt-portlet">
      <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
          <h3 class="kt-portlet__head-title">
         Update Budget 
          </h3>
        </div>
        <div class="kt-portlet__head-toolbar">
          <div class="kt-portlet__head-wrapper">
            <a href="<?php echo $_SERVER['HTTP_REFERER'] ?>" class="btn btn-primary text-white btn-icon-sm">
            <i class="la la-long-arrow-left"></i>Back</a>
          </div>
        </div>
      </div>
	<!--begin::Form-->
      <form class="kt-form kt-form--label-right" role="form" id="budget_edit_form" action="{{url('budgets/update/'.$id) }}" method="post">
      <div class="kt-portlet__body">
          <input type="hidden" name="_token" value="{!! csrf_token() !!}">
            <input type="hidden" value="{{Auth::user()->company_id}}" name="company_id" />
              @if(count($budgets)>0)
              @foreach($budgets as $row) 
          @if($row->id==$id)
          
          <div class="row">
            <div class="form-group  col-lg-6">
                <label for="deparment" class="">Department</label>
                <select class="form-control " id="deparment" name="category_id">
                  <option value="">Choose Department</option>
                  
                  @if(count($categories)>0)
                  @foreach($categories as $row1)
                    
                  <option value="{{$row1->id}}" <?php if($row1->id==$row->category_id){ echo 'selected="selected"'; }?>>{{$row1->name}}</option>
                  
                  @endforeach
                  @endif
                
                </select>
              </div>
              <div class=" form-group  col-lg-6">
                <label for="periods" class="">Periods</label>
                <select class="form-control" id="periods" name="period_id">
                  <option value="">Choose Period</option>
                  
                  @if(count($periods)>0)
                  @foreach($periods as $row2)
                    
                  <option value="{{$row2->id}}" <?php if($row2->id==$row->period_id){ echo 'selected="selected"'; }?>>{{$row2->name}}</option>
                  
                  @endforeach
                  @endif
                </select>
              </div>
          </div>
          <div class=" row">
            <div class="form-group col-lg-6">
              <label for="item" class="">Item</label>
              <input type="text" value="<?php echo $row->item; ?>" class="form-control" name="item">
            </div>
         
            <div class=" form-group col-lg-6">
              <label for="unit" class="">Unit Price ({{ \App\Providers\Common::currency_symbol()}})</label>
              <input type="text" value="<?php echo $row->unit; ?>" class="form-control" name="unit" onkeyup="calcBudget()">
            </div>
          </div>
              <div class=" row">
                <div class=" form-group col-lg-6">
                <label for="quantity" class="">Quantity</label>
                <input type="text" value="<?php echo $row->quantity; ?>" class="form-control" name="quantity" onkeyup="calcBudget()">
                </div>
              <div class=" form-group   col-lg-6">
              <label for="budget" class="">Budget ({{ \App\Providers\Common::currency_symbol()}})</label>
                <input type="text" value="<?php echo $row->budget; ?>" class="form-control" name="budget" readonly="readonly">
              </div>
            </div>
            @endif
			@endforeach
            @endif
         
        </div>
        <div class="kt-portlet__foot">
          <div class="kt-form__actions">
            <div class="row">
              <div class="col-lg-5"></div>
              <div class="col-lg-6">
                <button type="submit"class="btn btn-primary">Update</button>
                <button type="reset" class="btn btn-secondary">Clear Changes</button>
              </div>
            </div>
          </div>
        </div>
        </div>
      </form>
      <!--end::Form-->
    </div>
</div>
@endsection
@section("pagejs")
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/jquery.validate.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/additional-methods.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/custom/js/vendors/jquery-validation.init.js" type="text/javascript"></script>
<script>
function calcBudget(){
  var unit_per = $("input[name='unit']").val();
  var quantity = $("input[name='quantity']").val();
  var budget = unit_per*quantity;
  budget = parseFloat(budget);
  budget = budget.toFixed(0);
  $("input[name='budget']").val(budget);
}
$( "#budget_edit_form" ).validate({
  // define validation rules
  rules: {
    category_id: {
          required: true,
      },
      period_id: {
          required: true
      },
    item: {
              required: true 
          }, 
    unit: {
          required: true 
      },
      quantity: {
          required: true,
      },
      priority: {
          required: true,
      },
      budget: {
          required: true
      }
  },
  //display error alert on form submit  
  invalidHandler: function(event, validator) {     
     
  },

  submitHandler: function (form) {
      form[0].submit(); // submit the form
  }
});
</script>
@endsection