@extends("app")
@section("pagecss")
<link href="{{URL::asset('')}}assets/vendors/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/bootstrap-daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/vendors/general/sweetalert2/dist/sweetalert2.css" rel="stylesheet" type="text/css" />
@endsection
@section("content")
<div class="row">
  <div class="col-md-12">
    <div class="kt-portlet kt-portlet--mobile"> 
            @include("budgets.budget_periods.category")
            @include("budgets.budget_periods.list_category")
    </div>
  </div>
</div>
@stop
@section("pagejs")
<script src="{{URL::asset('')}}/assets/vendors/general/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/general/toastr/build/toastr.min.js" type="text/javascript"></script>
<script src="{{URL::asset('')}}assets/vendors/general/sweetalert2/dist/sweetalert2.min.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/jquery.validate.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/additional-methods.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/custom/js/vendors/jquery-validation.init.js" type="text/javascript"></script>
<script>
 
$('#kt_datepicker_5').datepicker();
$("#period-view-table,#category-view-table").DataTable({
	// DOM Layout settings
  dom: `<'row'<'col-sm-6 text-left'l><'col-sm-6 text-right'f>>
  <'row'<'col-sm-12'tr>>
  <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
			
			scrollY: false,
			scrollX: true,
			scrollCollapse: true,
			lengthMenu: [5, 10, 25, 50,],
			pageLength: 10,
			language: {
				'lengthMenu': 'Display _MENU_',
			},
			// Order settings
			order: [[1, 'desc']],
});
toastr.options = {
  "closeButton": true,
  "debug": false,
  "newestOnTop": false,
  "progressBar": false,
  "positionClass": "toast-top-right",
  "preventDuplicates": false,
  "onclick": null,
  "showDuration": "300",
  "hideDuration": "1000",
  "timeOut": "5000",
  "extendedTimeOut": "1000",
  "showEasing": "swing",
  "hideEasing": "linear",
  "showMethod": "fadeIn",
  "hideMethod": "fadeOut"
};
$( "#budgets_category_form" ).validate({
  // define validation rules
  rules: {
      name:{
        required:true,
      }
  },
  submitHandler: function (form) {
      form[0].submit(); // submit the form
  }
});
function category_delete(e){
e.preventDefault();
var urlToRedirect = e.currentTarget.getAttribute('href');
{	
	swal.fire({
		title: 'Are you sure?',
		text: "You won't be able to revert this!",
		type: 'error',
		showCancelButton: true,
		confirmButtonText: 'Yes, delete it!',
		cancelButtonText: 'No, cancel!',
		reverseButtons: true
	}).then(function(result){
		if(result.value){
			window.location.href= urlToRedirect ;	
		}
    else if (result.dismiss === 'cancel') {
			swal.fire(
				'Cancelled',
				'Data is safe :)',
				'error'
			)
		}
	});
}}
</script>
@if(Session::has("message"))
	<script>toastr.success("", "{{ Session::get("message") }}"); </script> 
@endif
@if(Session::has("error"))
<script> toastr.error("", "{{ Session::get("error") }}"); </script>
@endif
@endsection