@extends("authapp")

@section("authcontent")
<div class="col-sm-4"></div>
<div class="col-sm-4 register-top">
  <form class="form-horizontal register-container tb-padding" role="form" action="{{ url('password/reset') }}" method="post">
    {!! csrf_field() !!}
    <input type="hidden" name="token" value="{{ $token }}">
    <div class="form-group">
      <div class="col-md-12">
        <h3 class="text-center">Forgot Password?</h3>
      </div>
    </div>
    @if (count($errors) > 0)
        @foreach ($errors->all() as $error)
            <p class="text-danger">{{$error}}</p>
        @endforeach
    @endif    
    <div class="form-group">
      <div class="col-md-12">
        <input type="email" class="form-control" id="email" placeholder="Email" name="email" value="{{ old('email') }}">
      </div>
    </div>
    <div class="form-group">
      <div class="col-md-12">
        <input type="password" class="form-control" id="password" placeholder="Password" name="password">
      </div>
    </div>
    <div class="form-group">
      <div class="col-md-12">
        <input type="password" class="form-control" id="password_confirmation" placeholder="Password Confirmation" name="password_confirmation">
      </div>
    </div>
    <div class="form-group">
      <div class="col-md-12">
        <input type="submit" value="Reset Password" class="btn btn-danger btn-block">
      </div>
    </div>
  </form>
  <h5 class="text-center">Already have account? <a href="{{ url('auth/login') }}">Sign In</a></h5>
</div>
<div class="col-sm-4"></div>
@stop