@extends("authapp")
@section('pagecss')
<link href="{{URL::asset('')}}assets/vendors/general/select2/dist/css/select2.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/css/demo3/style.bundle.css" rel="stylesheet" type="text/css" />
<link href="{{URL::asset('')}}assets/css/demo1/pages/general/login/login-4.css" rel="stylesheet" type="text/css" /> 
<link href="{{URL::asset('')}}assets/css/custom/user-form.css" rel="stylesheet" type="text/css" /> 
@endsection
@section("authcontent")
<div class="kt-grid kt-grid--ver kt-grid--root">
  <div class="kt-grid kt-grid--hor kt-grid--root  kt-login kt-login--v4 kt-login--signin" >
    <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" style="background-image: url({{ URL::asset('/') }}assets/media/bg/bg-2.jpg);">
      <div class="kt-grid__item kt-grid__item--fluid kt-login__wrapper">
        <div class="kt-login__container">
          
        <div class="kt-login__logo " style="margin-bottom:10px;">
            <a href="#" class="pb-0">
              <img src="{{ URL::asset('/') }}assets/img/favicon.png">
            </a>
          </div>
      <div class="kt-login__signin" >
        <div class="kt-login__head">
          <h2 class="kt-login__title" >Sign Up to Smart Expense Keeping </h2>
        </div>
        @if($errors->any())
    @foreach($errors->all() as $error)
    <p class="text-danger">{{$error}}</p>
    @endforeach
    @endif
    @if(Session::has("message"))
    <p class="text-success">{{ Session::get("message") }}</p>
    @endif         
  <form class="kt-form" style="margin-top:10px;" id="register-form" role="form" action="{{ url('auth/register') }}" method="post" onsubmit="return false">
  <div class="kt-portlet__body">
    <div class="form-group form-group-marginless">
      <div class="row"> 
  <input type="hidden" name="_token" value="{{ csrf_token() }}">
  
      <div class="form-group col-md-6">
        <input type="text" class="form-control" autocomplete="off" id="name" name="name" placeholder="Full Name" value="{{old('name')}}">
      </div>
      <div class="form-group col-md-6">
         <input type="email" class="form-control" autocomplete="off" id="email" name="email" placeholder="Email" value="{{old('email')}}">
      </div>
      <div class="form-group col-md-6">
         <input type="password" class="form-control" autocomplete="off" id="password" name="password" placeholder="Password">
      </div>
      <div class="form-group col-md-6">
         <input type="password" class="form-control" autocomplete="off" id="password" name="password_confirmation" placeholder="Confirm Password">
      </div>
      <div class="form-group col-md-6">
         <input type="text" class="form-control" autocomplete="off" id="phone" placeholder="Phone" name="phone" value="{{old('phone')}}">
      </div>
    <div class="form-group col-md-6">
    <select class="form-control" id="country" name="country" onchange="get_states($(this).val())" >
                  <option value="">Choose Country</option>
                  @if(count($countries)>0)
                    @foreach($countries as $country)
                      <option value="{{$country->id}}">{{$country->name}}</option>
                    @endforeach
                  @endif
              </select> 
    </div>  
    
      
      <div class="form-group col-lg-6">
        <select class="form-control kt-select2" id="state" name="state" onchange="get_cities($(this).val())" >
            <option value="">Choose State</option>
        </select>   
      </div>
     
    
   
      <div class=" form-group col-md-6">
      <select class="form-control kt-select2" id="city" name="city" >
                    <option value="">Choose city</option>
                </select>
      </div>
    
    
      <div class="form-group col-md-6">
        <input type="tel" class="form-control" id="address" placeholder="Address" name="address" value="{{old('address')}}">
      </div>
   
    <div class="input-group col-md-6">
        <input type="tel" class="form-control" id="post_code" placeholder="Post Code" name="post_code" value="{{old('post_code')}}">
    </div>
</div>
      <div class="kt-login__actions">
        <input type="submit"  class="btn btn-brand btn-pill kt-login__btn-primary" onclick="validEmail()" value="Register" class="btn btn-danger btn-block">
	  </div>
  </form>
</div>
<div class="kt-login__account">
	<span class="kt-login__account-msg">	Already have an account ?</span>&nbsp;&nbsp;
	<a href="{{ url('auth/login') }}" class="kt-login__account-link">Log In!</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>



@section('pagejs')
<script src="{{URL::asset('/')}}assets/vendors/general/select2/dist/js/select2.full.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/js/scripts.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/inputmask/dist/jquery.inputmask.bundle.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/inputmask/dist/inputmask/inputmask.numeric.extensions.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/jquery.validate.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/general/jquery-validation/dist/additional-methods.js" type="text/javascript"></script>
<script src="{{URL::asset('/')}}assets/vendors/custom/js/vendors/jquery-validation.init.js" type="text/javascript"></script>

<script>
// $('#country').select2({
//     placeholder: "Select a country"
// });
$("#phone").inputmask("mask", {
"mask": "+(99) 999-9999999"
});
	// function get_zones(id){
	// 	$("#loader").show();
	// 	$.post("/auth/get_zones", {id:id, _token:"{{ csrf_token() }}"}).done(function(e){
	// 		$("#state").html(e);
	// 		$("#loader").hide();
	// 	});
	// }

  function get_states(id){
    $.get("{{ route('get_state') }}", {id:id, _token:"{{ csrf_token() }}"}).done(function(e){
        $("#state").html(e);
    });
}
function get_cities(id){
    $.get("{{ route('get_city') }}", {id:id, _token:"{{ csrf_token() }}"}).done(function(e){
        $("#city").html(e);
    });
}

	function validEmail(){
		var email = $("#email").val();
		var rejectList = ["aol.com"];
		var splitArray = email.split('@');
		if(rejectList.indexOf(splitArray[1]) >= 0){
			alert("Sorry! Your email is not valid.");
			return false;
		}
		document.getElementById("register-form").submit();
	}
</script>
@endsection

@stop