@extends("authapp")

@section("authcontent")
<div class="kt-grid kt-grid--ver kt-grid--root">
  <div class="kt-grid kt-grid--hor kt-grid--root  kt-login kt-login--v4 kt-login--signin" id="kt_login">
    <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" style="background-image: url({{ URL::asset('/') }}assets/media/bg/bg-2.jpg);">
      <div class="kt-grid__item kt-grid__item--fluid kt-login__wrapper">
        <div class="kt-login__container">
          <div class="kt-login__logo" style="margin-bottom:10px;">
            <a href="#">
              <img src="{{ URL::asset('/') }}assets/img/favicon.png">
            </a>
          </div>
          <div class="kt-login__signin">
            <div class="kt-login__head">
              <h3 class="kt-login__title">Login to Smart Expense Keeping</h3>
            </div>
            <form class="kt-form  " role="form" action="{{ url('auth/login') }}" method="post">
              <input type="hidden" name="_token" value="{!! csrf_token() !!}">
              @if($errors->any())
              @foreach($errors->all() as $error)
              <p class="text-danger">{{$error}}</p>
              @endforeach
              @endif
              
              @if(Session::has("message"))
              <p class="text-success">{{ Session::get("message") }}</p>
              @endif
              @if(Session::has("error"))
              <p class="text-danger">{{ Session::get("error") }}</p>
              @endif
              
              <div class="input-group">
                  <input type="email" class="form-control" id="email" autocomplete="off" placeholder="Email" name="email">
              </div>
              <div class="input-group">
                  <input type="password" class="form-control" id="password" autocomplete="off" placeholder="Password" name="password">
              </div>
              <div class="row kt-login__extra">
                <div class="col">
                  <label class="kt-checkbox">
                    <input type="checkbox" class="" id="" name="remember" >Remember me
                      <span></span>
                  </label>
                </div>
                <div class="col kt-align-right">
                  <a href="{{ url('password/email') }}" class="kt-login__link">Forget Password ?</a>
                </div>
              </div> 
              <div class="kt-login__actions">
                <input type="submit" class="btn btn-brand btn-pill kt-login__btn-primary" value="LOG IN">
              </div>     
              </form>
              <div class="kt-login__account">
                <span class="kt-login__account-msg">Don't have an account? </span> &nbsp;&nbsp;
                <a href="{{ url('auth/register') }}" class="kt-login__account-link">Sign Up!</a>
              </div>
						</div>
					</div>
				</div>
			</div>
    </div>
</div>
@stop