$("#users-view-table").DataTable({
	// DOM Layout settings
	dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right dataTables_pager'lp>>
  <'row'<'col-sm-12'tr>>
  <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
			
			scrollY: false,
			scrollX: true,
			scrollCollapse: true,

			lengthMenu: [5, 10, 25, 50,],

			pageLength: 10,

			language: {
				'lengthMenu': 'Display _MENU_',
			},

			// Order settings
			order: [[1, 'desc']],
});

function deleteuser(UserID)
{	
	swal.fire({
		title: 'Are you sure?',
		text: "You won't be able to revert this!",
		type: 'error',
		showCancelButton: true,
		confirmButtonText: 'Yes, delete it!',
		cancelButtonText: 'No, cancel!',
		reverseButtons: true
	}).then(function(result){
		if (result.value) {
			$.get("{{ route('User_delete') }}",{"_token": "{{ csrf_token() }}",UserID:UserID}).done(function(data){
				swal.fire(
				'Deleted!',
				'User has been deleted.',
				'success'
				);
				$('#user_detail_'+UserID+'').remove();	
			});
			
		} else if (result.dismiss === 'cancel') {
			swal.fire(
				'Cancelled',
				'User is safe :)',
				'error'
			)
		}
	});
}
toastr.options = {
  "closeButton": true,
  "debug": false,
  "newestOnTop": false,
  "progressBar": false,
  "positionClass": "toast-top-right",
  "preventDuplicates": false,
  "onclick": null,
  "showDuration": "300",
  "hideDuration": "1000",
  "timeOut": "5000",
  "extendedTimeOut": "1000",
  "showEasing": "swing",
  "hideEasing": "linear",
  "showMethod": "fadeIn",
  "hideMethod": "fadeOut"
};