<?php

namespace App;

use DB, Auth;
use Illuminate\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Passwords\CanResetPassword;
use Illuminate\Foundation\Auth\Access\Authorizable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Contracts\Auth\Access\Authorizable as AuthorizableContract;
use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;
error_reporting(E_ALL);
class User extends Model implements AuthenticatableContract,
                                    AuthorizableContract,
                                    CanResetPasswordContract
{
    use Authenticatable, Authorizable, CanResetPassword;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'users';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['parent_id', 'name', 'email', 'password','phone','address','country', 'state', 'post_code', 'status', 'role','profilepic','gender','city','company_id'];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = ['password', 'remember_token'];
	
	public function periods()
	{
		return $this->hasMany('App\Periods');
	}
	public function categories()
	{
		return $this->hasMany('App\Categories');
	}
	public function budgets()
	{
		return $this->hasMany('App\Budgets');
	}
	public function companies()
	{
		return $this->hasMany('App\Companies');
	}
	public function roles()
    {
		$table	= DB::table('roles');
		return $table->get();
	}
	public function comp_nam()
	{
		$sql=DB::select(DB::raw("select * from companies;"));
		return $sql;
	}
	public function user_logo()
	{
		$sql=DB::select(DB::raw("select * from users;"));
		return $sql;
	}
	public function curr_name()
	{
		$sql=DB::select(DB::raw("select * from currency;"));
		return $sql;
	}
	
	public function whereUser($id=NULL)
    {
		$parent_id = Auth::user()->parent_id;
		if(Auth::user()->parent_id==0){
			$parent_id = Auth::user()->id;
		}
		$table = DB::table('users as u');
		$table->where('u.parent_id', $parent_id);
		if($id!=NULL){$table->where('u.id', $id);}
		if($id==NULL){
			$table->select('u.id', 'u.name', 'u.email', 'u.phone', 'u.status', 'r.role','u.profilepic','u.gender');
			$table->leftJoin('roles as r', 'u.role', '=', 'r.id');
		}
		return $table->get();	
	}
	public function exists($id=NULL, $company_id, $department_id=NULL)
    {
		$parent_id = Auth::user()->parent_id;
		if(Auth::user()->parent_id==0){
			$parent_id = Auth::user()->id;
		}
		$table = DB::table('user_companies');
		$table->where('user_id', $id);
		$table->where('company_id',$company_id);
		if($department_id!=NULL){
			$table->where('department_id', $department_id);
		}
		$result = $table->get();
		if(count($result)>0){
			return TRUE;	
		}
		return FALSE;
	}
}
