<?php

namespace App\Providers;
use Auth;
use \App\Budgets;
use \App\Expenses;
use App\Companies;
use Illuminate\Support\ServiceProvider;

class Common extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }

  

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
	
	/**
	 * Get colors use in the side bars of the application
	 */
	public static function colors()
	{
		return ['blue', 'yellow', 'red', 'magenta', 'green', 'violet', 'gray', 'brown', 'purple', 'fuchsia'];	
	}
	
	/**
	 * Make helper function to use currency and format of the price
	 */
	public static function format_currency($value)
	{
		$companies=new companies();
		$company=\App\companies::company_currency_symbol();
		
		foreach($company as $row)
		  $company_currency=$row->symbol;
		  
		$value = number_format($value, 0);
		$value = $company_currency." ".$value;
		return $value;
	}

	public static function currency_symbol()
	{
		$companies=new companies();
		$company=\App\companies::company_currency_symbol();
		
		foreach($company as $row)
		  $company_currency=$row->symbol;
		  
		//$value = number_format($value, 0);
		$value = $company_currency;
		return $value;
	}
	
	/**
	 * Date Formatting
	 */
	public static function format_date($date)
        {
		return date('F d, Y', strtotime($date));
	}	
	
	
	
}
