<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Route;

Route::get('/clear-cache', function() {
	Artisan::call('config:clear');
	return Redirect::to('auth/login');
});

// Home routes...
Route::get('/', function () {
	
	if(Auth::guest()){

		return Redirect::to('auth/login');	
	}
	if(Auth::check()){
		return Redirect::to('home');	
	}
});
//Route::get('/', 'HomeController@index');
Route::get('home', 'HomeController@index');
Route::get('graph','ReportController@charts');
Route::get('download_expense', 'CsvController@export_expense');
Route::get('download_budget', 'CsvController@export_budget');

Route::get('budget-reports', 'ReportController@budgetreport');
Route::get('expense-reports', 'ReportController@expensereport');
Route::get('reps', 'ReportController@rep');



// Authentication routes...
Route::get('auth/login', 'Auth\AuthController@getLogin');
Route::post('auth/login', 'Auth\AuthController@postLogin');
Route::get('auth/logout', 'Auth\AuthController@getLogout');

// Registration routes...
Route::get('auth/register', 'Auth\AuthController@getRegister');
Route::post('auth/get_zones', 'Auth\AuthController@get_zones');
Route::get('auth/get_states/{id}', 'Auth\AuthController@get_states')->name('get_state');
Route::get('auth/get_cities/{id}', 'Auth\AuthController@get_cities')->name('get_city');
Route::post('auth/register', 'Auth\AuthController@postRegister');

// Companies Name and Symbols routes...
Route::get('companies', 'CompaniesController@index');
Route::post('companies/store', 'CompaniesController@store');
Route::get('companies/create', 'CompaniesController@create');
Route::get('companies/edit/{id}', 'CompaniesController@edit');
Route::get('companies/active', 'CompaniesController@active');
Route::post('companies/update/{id}', 'CompaniesController@update');
Route::get('companies/get_symbol_value', 'CompaniesController@get_symbol_value')->name('symbol_values');
Route::get('companies/symbol_value', 'CompaniesController@symbol_value')->name('assigned_symbol');

// Expenses routes...
Route::get('expenses', 'ExpensesController@index');
Route::get('expenses/create', 'ExpensesController@create');
Route::post('expenses/store', 'ExpensesController@store');
Route::get('expenses/editrequest/{id}', 'ExpensesController@editrequest');
Route::post('expenses/request_update/{id}', 'ExpensesController@request_update');
Route::post('expenses/edit', 'ExpensesController@editStatus')->name('expenses_edit');
Route::get('expenses/show/{id}', 'ExpensesController@show');
Route::post('expenses/search', 'ExpensesController@search');
Route::post('expenses/updatestatus', 'ExpensesController@updatestatussingle');
Route::post('expenses/get_period', 'ExpensesController@get_period')->name('expense_periods');
Route::post('expenses/get_budget', 'ExpensesController@get_budget')->name('get_budgets');
Route::post('expenses/get_value', 'ExpensesController@get_value')->name('get_amount');




// Budgets routes...
Route::get('budgets', 'BudgetsController@index');
/*Route::get('budgets/{id}', 'BudgetsController@index');*/
Route::get('budgets/create', 'BudgetsController@create');
Route::post('budgets/store', 'BudgetsController@store');
Route::get('budgets/delete/{id}', 'BudgetsController@budget_delete');
Route::get('budgets/edit/{id}', 'BudgetsController@edit');
Route::post('budgets/update/{id}', 'BudgetsController@update');


// Periods routes...
Route::get('budgets/periods', 'BudgetsController@budget_periods');
Route::get('budgets/categories', 'BudgetsController@budget_categories');
Route::post('budgets/periods/create', 'BudgetsController@periods_create');
Route::get('budgets/periods/{id}', 'BudgetsController@periods_show');
Route::get('budgets/periods/update/{id}', 'BudgetsController@update_period');
Route::post('budgets/periods/period_update/{id}', 'BudgetsController@period_update');
Route::get('budgets/periods/delete/{id}', 'BudgetsController@periods_delete');

// Categories routes...
Route::post('budgets/categories/create', 'BudgetsController@categories_create');
Route::get('budgets/categories/update/{id}', 'BudgetsController@categories_update');
Route::post('budgets/categories/update_category/{id}', 'BudgetsController@update_category');
Route::get('budgets/categories/delete/{id}', 'BudgetsController@categories_delete');

// Profile routes...
Route::get('/profile', 'ProfileController@index');
Route::post('/profile/edit/{id}', 'ProfileController@edit');
Route::post('/profile/update/{id}', 'ProfileController@update');
Route::get('/password', 'ProfileController@change_password');

// Password reset link request routes...
Route::get('password/email', 'Auth\PasswordController@getEmail');
Route::post('password/email', 'Auth\PasswordController@postEmail');

// Password reset routes...
Route::get('password/reset/{token}', 'Auth\PasswordController@getReset');
Route::post('password/reset', 'Auth\PasswordController@postReset');


// Users routes...
Route::get('users','UsersController@index');
Route::get('users/create', 'UsersController@create');
Route::post('users/store', 'UsersController@store');
Route::get('users/edit/{id}', 'UsersController@edit');
Route::post('users/update/{id}', 'UsersController@update');
Route::get('users/destroy/{id}', 'UsersController@destroy')->name('User_delete');
Route::get('users/get_states/{id}', 'UsersController@get_states')->name('Get_states');
Route::get('users/get_cities/{id}', 'UsersController@get_cities')->name('Get_cities');
