<?php

namespace App\Http\Controllers;

use App\User, App\Companies, App\Categories, Auth, App\user_companies , App\Countries ,App\States, App\Cities;
use Illuminate\Http\Request;
use DB;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Http\Requests\CreateUsersRequest;
error_reporting(E_ALL);
class UsersController extends Controller
{
		/**
		 * Display a listing of the resource.
		 *
		 * @return \Illuminate\Http\Response
		 */
		protected $users, $companies, $departments, $countries;
		
		public function __construct()
		{
                        
			$this->middleware('auth');
			$this->users 		= new User();
			$this->companies 	= new Companies();
                        $this->departments 	= new Categories();
                        $this->countries        = new Countries();
                        $this->states           = new States();
                        $this->cities           = new Cities();
                        
		}
        public function index()
        {
                    if(Auth::user()->role==2){
                        return redirect('/home')->with('error', 'Access denied you do not have sufficient privileges.');
                    }
                    $data['title']	= trans('app.users-title');
                    $data['users']	= $this->users->whereUser();
                    return View('users.index', $data);
        }

        /**
         * Show the form for creating a new resource.
         *
         * @return \Illuminate\Http\Response
         */
        public function create()
        {
                    if(Auth::user()->role==2){
                        return redirect('/home')->with('error', 'Access denied you do not have sufficient privileges.');
                    }
                    $data['title']          = trans('app.users-add_new');
                    $data['countries']      = $this->countries->all();
                    $data['roles']          = $this->users->roles();
                    $data['companies']      = $this->companies->whereUser();
                    $data['departments']    = $this->departments->whereUser();
                    
                    return View('users.create', $data);
        }

        public function get_states() {
                $id = $_GET['id'];
                $states = $this->countries->states($id);
                if(count($states)>0){
                        foreach($states as $state){
                                echo '<option value="'.$state->id.'">'.$state->name.'</option>';
                        }
                }
            }

        public function get_cities() {
                $id = $_GET['id'];
                $cities = $this->states->cities($id);
                if(count($cities)>0){
                        foreach($cities as $city){
                                echo '<option value="'.$city->id.'">'.$city->name.'</option>';
                        }
                }
        }

        /**
         * Store a newly created resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @return \Illuminate\Http\Response
         */
        public function store(CreateUsersRequest $request)
        {              
                //echo "<pre>"; print_r($request->company_id);exit;
                $parent_id = Auth::user()->id;
                if ($request->file('profilepic') && $request->file('profilepic')->isValid()){
                        $destinationPath = './uploads/';
                        $filename = time().'.png';
                        $request->file('profilepic')->move($destinationPath, $filename);
                        $data['profilepic'] = $filename;
                }
                $data['parent_id']	= $parent_id;
                $data['country']	= $request->country;
                $data['state']  	= $request->state;
                $data['name']	        = $request->name;
                $data['email']	        = $request->email;
                $data['password']	= bcrypt($request->password);
                $data['phone']	        = $request->phone;
                $data['city']	        = $request->city;
                $data['address']	= $request->address;
                $data['post_code']	= $request->post_code;
                $data['company_id']	= $request->company_id;
                $data['role']	        = $request->role;
                $data['status']	        = $request->status;
                $data['gender']         = $request->gender;
                $users = new User($data);
                $users->save();
                $last_inserted_id = $users->id;
                if(count($request->access)>0){ 
                        foreach($request->access as $val){

                                // $company_categories = $this->departments->select('id')->where('company_id',$val)->get();
                                // if(count($company_categories)>0){
                                //         foreach($company_categories as $cat){
                                //                 $user_detail = new user_companies();
                                //                 $user_detail['user_id'] = $last_inserted_id;
                                //                 $user_detail['company_id'] = $val;
                                //                 $user_detail['department_id'] = $cat->id;
                                //                 $user_detail->save();
                                //         }
                                // }
                                // else{
                                        $user_detail = new user_companies();
                                        $user_detail['user_id'] = $last_inserted_id;
                                        $user_detail['company_id'] = $val;
                                        $user_detail->save();    
                                //}
                               
                        }
                       
                }
                return redirect('/users')->with('message', 'New Record Inserted.');
        }

        /**
         * Display the specified resource.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function show($id)
        {
            //
        }

        /**
         * Show the form for editing the specified resource.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function edit($id)
        {
                if(Auth::user()->role==2){
                        return redirect('/home')->with('error', 'Access denied you do not have sufficient privileges.');
                    }
                $data['title']			= trans('app.users-edit');
                $data['countries']              = $this->countries->all();
                $data['roles']			= $this->users->roles();
                $data['companies']              = $this->companies->whereUser();
                $data['departments']            = $this->departments->whereUser();
                $data['row']			= $this->users->whereUser($id);
                $data['row']			= $data['row'][0];
                $data['states']                 = $this->states->where('country_id',$data['row']->country)->get();
                $data['cities']                 = $this->cities->where('state_id',$data['row']->state)->get();
                $data['ude']			= $this->users;
                $data['id']		        = $id;
                //echo "<pre>"; print_r($data['companies']); exit;
                return View('users.edit', $data);
        }

        /**
         * Update the specified resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function update(Request $request, $id)
        {                       
               // echo "<pre>"; print_r($_POST);exit;

                $users = User::find($id);
                if ($request->file('profilepic') && $request->file('profilepic')->isValid()) {
                $destinationPath = './uploads/';
                $filename = time().'.png';
                $request->file('profilepic')->move($destinationPath, $filename);
                $users->profilepic = $filename;
                }
                $users->name		= $request->name;
                $users->phone		= $request->phone;
                $users->country		= $request->country;
                $users->city		= $request->city;
                $users->address		= $request->address;
                $users->post_code       = $request->post_code;
                $users->role		= $request->role;
                $users->status		= $request->status;
                $users->gender		= $request->gender;
                $users->company_id      = $request->company_id;
                $users->save();
                if(count($request->access)>0){
                        user_companies::where('user_id', $id)->delete(); 
                        foreach($request->access as $val){
                                // $company_categories = $this->departments->select('id')->where('company_id',$val)->get();
                                // if(count($company_categories)>0){
                                //         foreach($company_categories as $cat){
                                //                 $user_detail = new user_companies();
                                //                 $user_detail['user_id'] = $id;
                                //                 $user_detail['company_id'] = $val;
                                //                 $user_detail['department_id'] = $cat->id;
                                //                 $user_detail->save();
                                //         }
                                // }
                                // else{
                                        $user_detail = new user_companies();
                                        $user_detail['user_id'] = $id;
                                        $user_detail['company_id'] = $val;
                                        //$user_detail['department_id'] = 0;
                                        $user_detail->save();    
                                //}
                               
                        }
                       
                }
                return redirect('/users')->with('message', 'Record Updated.');
        }
        /**
         * Remove the specified resource from storage.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function destroy()
        {       
                if(Auth::user()->role==2){
                        return redirect('/home')->with('error', 'Access denied you do not have sufficient privileges.');
                    }
                $id = $_GET['UserID'];
                User::where('id', $id)->delete();
                user_companies::where('user_id', $id)->delete();
                
        }
}
