<?php

namespace App\Http\Controllers;

use Auth, Storage;
use Illuminate\Http\Request;
use App\Countries;
use App\Http\Requests;
use App\Http\Controllers\Controller;
error_reporting(E_ALL);
class ProfileController extends Controller
{
		/**
		 * Display a listing of the resource.
		 *
		 * @return \Illuminate\Http\Response
		 */
		protected $countries;
		 
		public function __construct()
		{
			$this->middleware('auth');
			$this->countries 	= new Countries();
			$this->colors 		= \App\Providers\Common::colors();
		}

        public function index()
        {
                $data['title']		= trans('app.profile');
                $data['countries']	= $this->countries->all();
                $data['profile']	= Auth::user();
                return View('profile.index', $data);
        }
        public function change_password()
        {       $data['title']  = trans('app.profile');
                $data['profile']	= Auth::user();
                return View('profile.change_password',$data);
        }
        /**
         * Show the form for creating a new resource.
         *
         * @return \Illuminate\Http\Response
         */
        public function create()
        {
            //
        }

        /**
         * Store a newly created resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @return \Illuminate\Http\Response
         */
        public function store(Request $request)
        {
            //
        }

        /**
         * Display the specified resource.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function show($id)
        {
            //
        }

        /**
         * Show the form for editing the specified resource.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function edit($id, Request $request)
        {
                    $user = Auth::user();
                    $edit = \App\User::find($user->id);
                    if ($request->file('profilepic') && $request->file('profilepic')->isValid()) {
                            if($user->profilepic!=""){
                                    if(file_exists(public_path('./uploads/'.$user->profilepic))){
                                            unlink(public_path('./uploads/'.$user->profilepic));
                                    }
                            }
                            $destinationPath = './uploads/';
                            $filename = time().'.png';
                            $request->file('profilepic')->move($destinationPath, $filename);
                            $edit->profilepic = $filename;
                    }
                    $edit->name 		= $request->name;
                    $edit->phone		= $request->phone;
                    $edit->address		= $request->address;
                    $edit->post_code            = $request->post_code;
                    $edit->save();
                    return redirect('/profile')->with('message', 'Save Changes.');
        }

        /**
         * Update the specified resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function update(Request $request, $id)
        {
                    $password	= $request->password;
                    $c_password = $request->c_password;
                    if($password!=$c_password){
                            return redirect('/profile')->with('error', 'Your password does not match.');
                    }
                    $user               = Auth::user();
                    $edit               = \App\User::find($user->id);
                    $edit->password	= bcrypt($password);
                    $edit->save();
                    return redirect('/profile')->with('message', 'Save Changes.');
        }

        /**
         * Remove the specified resource from storage.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function destroy($id)
        {
            //
        }
}
