<?php

namespace App\Http\Controllers;

use  Input, App\User;
use Illuminate\Http\Request;
use Auth,DB;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use \App\Expenses;
use \App\Budgets;
use \App\Categories;
use \App\Periods;
use \App\Companies;

error_reporting(E_ALL);
class HomeController extends Controller
{
	public function __construct()
	{
		$this->middleware('auth');
		$this->expenses	= new Expenses();
		
		$this->budgets 		= new Budgets();
		$this->colors 		= \App\Providers\Common::colors();
		$this->categories 	= new Categories();
		$this->periods 		= new Periods();
		$this->companies    = new Companies();
	}
	
    public function index(Request $request)
    {
		////////// Expense History//////////
		if(Auth::user()->company_id==NULL){
            return redirect("/companies")->with("error", "Please Create/Select Your comapny first.");
                }
		 		
		$data['status']		= 'all';
		$data['department']	= 'all';
		$data['page']		= array
			(
                            'department' => 'all',
                            'status' => 'all',
                            'period' => 'all',
			);
		$data['period']		= 'all';
		$data['limit']		= 10;
        $data['title']		= trans('expenses.title');
		$data['expenses']	= $this->expenses->getAllExpensesHome();
		$data['colors']		= $this->colors;
		$data['categories'] = $this->categories->whereUser();
		$data['periods']	= $this->periods->whereUser(); 

		$data["title"]	= trans('home.title');
		$CompanyID = Auth::user()->company_id;
		$UserId = Auth::user()->id;
		
		
		// Close Expenses according to their priorities
		$this->expenses->closeprojects($UserId,$CompanyID);
		///////////////////////////////////////////////
		$data['budgets']			= $this->budgets->whereUser();
		$data['info']				= $this->budgets->whereUserTotalhome();
		$data['info']				= $data['info'][0];
		$data['Pending'] 			= $this->expenses->dashboard_data($UserId,$CompanyID,'Pending');
		$data['Approved']			= $this->expenses->dashboard_data($UserId,$CompanyID,'Approved');
		$data['Overdue'] 			= $this->expenses->dashboard_data($UserId,$CompanyID,'Overdue');
		$data['Closed'] 			= $this->expenses->dashboard_data($UserId,$CompanyID,'Closed');
		$data['category_names']		= $this->budgets->category();
        $data['periods'] 			= $this->periods->whereUser();
		$data['currency_symbol']	= $this->companies->company_currency_symbol();
		
		if(isset($request->periods)){
			$data['requestperiod'] = $request->periods;
		}
	    $data['chart_data']=$this->expenses->chart($request);
	    $data['chart_data1']=$this->expenses->piechart();
		
		return View('home.index',$data);
	
	}
	
				
}