<?php

namespace App\Http\Controllers;

use Illuminate\Pagination\Paginator;
use Illuminate\Http\Request;

use Auth, DB, Input, Redirect;
use App\Budgets;
use App\Expenses;
use App\Categories;
use App\Periods;
use \App\Companies;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Http\Requests\CreateExpensesRequest;
error_reporting(E_ALL);
class ExpensesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
	
	protected $budgets, $expenses, $colors, $categories, $periods;
	
	public function __construct()
	{
		$this->middleware('auth');
		$this->budgets      = new Budgets();
		$this->expenses     = new Expenses();
		$this->colors 		= \App\Providers\Common::colors();
		$this->categories 	= new Categories();
		$this->periods 		= new Periods();
		$this->companies    = new Companies();
	}
	
        public function index()
        {
            if(Auth::user()->company_id==NULL){
                return redirect("/companies")->with("error", "Please Create/Select Your company first.");
            }
            if(Input::get('department')==false || Input::get('status')==false){
                return redirect('/expenses?department=all&status=all&period=all');
            }
            
            $data['status']		        = Input::get('status');
            $data['department']         = Input::get('department');
            $data['page']		        = Input::get('page');
            $data['period']		        = Input::get('period');
            $data['title']		        = trans('expenses.title');
            $data['expenses']           = $this->expenses->getAll();
            $data['expense_user_id']    = $this->expenses->select('user_id')->get();
            $data['expense_user_id']    = $data['expense_user_id'][0];    
            $data['colors']		        = $this->colors;
            $data['categories']         = $this->categories->whereUser();
            $data['periods']            = $this->periods->whereUser();
            $data['expenses']           = $data['expenses']->appends(Input::except('page'));
            $data['currency_symbol']    =  $this->companies->company_currency_symbol();
            
            return View('expenses.index', $data);
        }

        /**
         * Show the form for creating a new resource.
         *
         * @return \Illuminate\Http\Response
         */
        public function create()
        {
                    $data['title']	             = trans('expenses.create');
                    $data['budgets']	         = $this->budgets->whereUser();
					 $data['periods']            = $this->periods->whereUser();
                                                 return View('expenses.create', $data);
        }
		
		
		public function get_period()
        {
			     $id= intval(Input::get('vals'));
				 
				
		  
          $query1=DB::select(DB::raw("SELECT * from budgets"));	
		  
		  $query2=DB::select(DB::raw("SELECT b.id id, b.company_id, b.period_id, b.category_id , b.item item, b.unit, b.quantity, b.budget, 
                 b.created_at, b.updated_at
                 FROM budgets b
                 INNER JOIN periods p ON b.period_id = p.id
                 WHERE b.company_id ='".Auth::user()->company_id."' AND p.id=".$id."
                 GROUP BY b.id ORDER BY b.id ASC"));				
		 		  		

		  
		 
		  echo "<div class='form-group '>
               <label for='deparment' class='label-control'>Item</label>
                 <select class='form-control required' required='' name='budget_id' id='budget_id' onchange='get_budget_balance($(this).val())'>"; 			 
			  echo '<option value=""> Select Option</option>'; 
            foreach($query1 as $row1){			
          
						
				foreach($query2 as $row){
					 if($row->id==$row1->id)
					{ 
                        				 
				        echo "<option id='result'  value='".$row->id. "' >".$row->item."</option>";
					}
				}
			}					  
			echo "</select>
            </div>";   
		}
		public function get_budget()
		{
		  	$budget_id= intval(Input::get('val'));
			
			$balance_value=DB::select(DB::raw("SELECT budget-(SELECT IFNULL(SUM(price),0) 
			FROM expenses 
			WHERE expenses.`budget_id`=budgets.`id`) AS balance 
			FROM budgets WHERE budgets.id=".$budget_id." ;"));
			
			foreach($balance_value as $row){
				return $row->balance;
			}
		
		}
		public function get_value()
		{
		  	$budget_id= intval(Input::get('value'));
			
			$remaining=DB::select(DB::raw("SELECT budget-(SELECT IFNULL(SUM(price),0) 
			FROM expenses 
			WHERE expenses.`budget_id`=budgets.`id`) AS balance 
			FROM budgets WHERE budgets.id=".$budget_id." ;"));
			
			foreach($remaining as $row){
				return $row->balance;
			}
		}
        /**
         * Store a newly created resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @return \Illuminate\Http\Response
            */
        public function store(CreateExpensesRequest $request)  
        {  
		    $budget_id                  = explode(":", $request->budget_id);
            $request->budget_id         = $budget_id[0];
            $expenses                   = new Expenses($request->all());
            $expenses->user_id          = Auth::user()->id;
            $expenses['expense_date']   = date("Y-m-d", strtotime($expenses['expense_date']));
            if ($request->file('file') && $request->file('file')->isValid()){
            $destinationPath = './uploads/';
            $filename = time().'.png';
            $request->file('file')->move($destinationPath, $filename);
            $expenses->file = $filename;
            }	
            $expenses->save();
            return redirect('/expenses')->with('message', 'New Record Inserted.');
        }
		public function editStatus(Request $request)
		{       
			    $status = $_POST['status'];
			    foreach($_POST['expenses'] as $row){ 
				$expense = \App\Expenses::find($row);
				$expense->status = $status;
				$expense->comments = $_POST['comments'][$row];
				$expense->approver_id = Auth::user()->id;
				$expense->save();
			} 
			return Redirect::back()->with('message','Save Changes!');
			
		}
	
		public function updatestatussingle(Request $request)
		{
			$ExpenseID = $_POST['expenseid'];
			$Status = $_POST['newstatus'];
			$Comment = $_POST['commentbox'];
			$expense            = \App\Expenses::find($ExpenseID);
			$expense->status    = $Status;
			$expense->comments   = $Comment;
			$expense->approver_id = Auth::user()->id;
			$expense->save();
		}
	
		public function search(Request $request)
		{
			$request = $request->all();
			return redirect('/expenses?department=all&status=all&period=all&expense='.$request['search']);
		}

        /**
         * Display the specified resource.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function show($id)
        {
                    $expenses	    = $this->expenses->getAll($id);
                    $data['row'] 	= $expenses[0];
                    return View('expenses.detail', $data);
        }

        public function editrequest($id)
        {       
                $data['title']	             = trans('expenses.create');
                $data['expense']             = $this->expenses->where('id',$id)->get();
                $data['expense']             = $data['expense'][0];
                $data['expense_item']	     = $this->budgets->where('id',$data['expense']->budget_id)->get();
                $data['expense_item']        = $data['expense_item'][0];
                $data['budgets']	         = $this->budgets->whereUser();
                $data['periods']             = $this->periods->whereUser();
                return View('expenses.editrequest',$data);
        }

        public function request_update(Request $request,$id)  
        { 
            //echo "<pre>"; print_r($_POST);exit;
            $expense               = \App\Expenses::find($id);

			$expense->budget_id     = $request->budget_id;
            $expense->period_id     = $request->period_id;
            $expense->company_id    = $request->company_id;
            $expense->price         = $request->price;
            $expense->outside       = $request->outside;
            $expense->subject       = $request->subject;
            $expense->priority      = $request->priority;
            $expense->description   = $request->description;
            $expense->expense_date  = date("Y-m-d", strtotime($request->expense_date));
            if ($request->file('file') && $request->file('file')->isValid()){
                $destinationPath = './uploads/';
                $filename = time().'.png';
                $request->file('file')->move($destinationPath, $filename);
                $expense->file = $filename;
                }
			$expense->save();
            return redirect('/expenses')->with('message', 'Record Updated Successfully.');
        }

        /**
         * Show the form for editing the specified resource.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function edit($id)
        {
            //
        }

        /**
         * Update the specified resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function update(Request $request, $id)
        {
            //
        }

        /**
         * Remove the specified resource from storage.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function destroy($id)
        {
            //
        }
		
		
		
		
}
