<?php 
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Auth, Input, App\User;
use App\Companies;
use App\Http\Requests;
use App\Http\Requests\CreateCompaniesRequest;

error_reporting(E_ALL);
class CsvController extends Controller
{
	 
  	protected $companies, $users;
	 
	public function __construct()
	{
		$this->middleware('auth');
		$this->companies	= new Companies();	
		$this->users		= new User();
		$this->colors 		= \App\Providers\Common::colors();
	}
	
    /*Export Data*/
    public function export_expense(Request $request)
	{       
      
	       
			   
		  $sql=DB::raw("SELECT YEAR(e.expense_date) as y ,MONTH(e.expense_date) as mnt,
          pe.name as p_name,
		  e.expense_date as e_date,c.name as c_name,e.subject as e_sub,
		  e.price as e_price,e.status as e_status  
		  FROM expenses as e join budgets as b on e.budget_id=b.id 
		  left join categories as c on b.category_id=c.id 
		  left join periods as pe on e.period_id=pe.id
		  where e.company_id='".Auth::user()->company_id."';");
			   
			   
		       
			 $data_expense=DB::select($sql);

             $total_record_found=0;
            
			 if(count($data_expense)>0){
             
				 $total_record_found=1;
				  //First Method          
				  $export_data=" Period Name , Department , Subject , Amount , Status \n";
				 foreach($data_expense as $value){
				   
					$export_data.=$value->p_name.",".$value->c_name.",".$value->e_sub.",".$value->e_price.",".$value->e_status."\n";
		            }
                 return response($export_data)
                 ->header('Content-Type','application/csv')               
                 ->header('Content-Disposition','attachment; filename="Expenses.csv"')
                 ->header('Pragma','no-cache')
                 ->header('Expires','0');                     
                }
		$data['record_found']=$total_record_found;
		
        return view('download_expense',$data);    
    }
     

    public function export_budget(Request $request)
	{       
	
		$sql=DB::raw("SELECT YEAR(b.created_at) as y,MONTH(b.created_at) as month,
			 ct.name as c_name,b.item as b_item , b.unit as b_unit ,b.quantity as b_quantity,
			 b.budget as budget ,pe.name as p_name,(select ifnull(sum(e.price),0) 
			 from expenses e where e.budget_id=b.id and e.status='Approved') as expense,
			 (b.budget -(select ifnull(sum(e.price),0) 
			 From expenses e where e.budget_id=b.id and e.status='Approved')) as remaining
			 FROM budgets as b left join categories as ct on b.category_id=ct.id 
			 left join companies as c on b.company_id=c.id 
			 left join periods as pe on b.period_id=pe.id 
			 where b.company_id='".Auth::user()->company_id."'");
		
		$data_budget=DB::select($sql);
		
        $total_record_found=0;
         
		if(count($data_budget)>0){
           
		    $total_record_found=1;
            //First Method          
            $export_data="Period Name , Department , Item , Quantity , Unit  , Budget , Expense , Remaining budget \n";
            foreach($data_budget as $value){
              
                $export_data.=$value->p_name.",".$value->c_name.",".$value->b_item.",".$value->b_quantity
				." ,".$value->b_unit.",".$value->budget." ,".$value->expense.",".$value->remaining."\n";
		    }
                return response($export_data)
                ->header('Content-Type','application/csv')               
                ->header('Content-Disposition','attachment; filename="Budgets.csv"')
                ->header('Pragma','no-cache')
                ->header('Expires','0');                     
        }
		$data['record_found']=$total_record_found;
        return view('download_budget',$data);    
    }
     
	 	 
}   