<?php

namespace App\Http\Controllers;

use Auth, Input, App\User, DB;
use App\Companies;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Http\Requests\CreateCompaniesRequest;
error_reporting(E_ALL);

class CompaniesController extends Controller
{
		/**
		 * Display a listing of the resource.
		 *
		 * @return \Illuminate\Http\Response
		 */
		protected $companies, $colors, $users;
		
		public function __construct()
		{
			$this->middleware('auth');
			$this->companies	= new Companies();	
			$this->users		= new User();
			$this->colors 		= \App\Providers\Common::colors();
		}
		
        public function index()
        {
                    //return Auth::user()->active_company;
                    $data['title']		= trans('app.companies-title');
                    $data['companies']  = $this->companies->whereUser();
                    $data['colors']		= $this->colors;
                    $data['users']		= $this->users;
                    return View('companies.index', $data);
        }

        /**
         * Show the form for creating a new resource.
         *
         * @return \Illuminate\Http\Response
         */
        public function create()
        {
                    $data['title']	  = trans('app.companies-create');
					$data['currency'] =$this->companies->currency_data();
                    return View('companies.create', $data);
        }

        /**
         * Store a newly created resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @return \Illuminate\Http\Response
         */
		 
		 /* public function store(CreateCompaniesRequest $request) */
		 
		 
        public function store()
        { 
		
            if (\Input::file('logo') && \Input::file('logo')->isValid()) {
                $destinationPath = './uploads/';
                $filename = time().'.png';
                \Input::file('logo')->move($destinationPath, $filename);
                $logo = $filename;
                                }
            else{ $logo = "logo.png"; }
                    
                    $companies = new Companies();
					
					$companies->fill(array(
									'id' => \Input::get('id'),
									'user_id' => \Input::get('user_id'),
                                    'name' => \Input::get('name'),
                                    'logo' => $logo
								));
							$companies->currencies = \Input::get('currency');
							$companies->symbol= \Input::get('symbol');
					
					
					
                    Auth::user()->companies()->save($companies);
                    return redirect('/companies')->with('message', 'New Company Created.');
        }
	
		public function active()
		{
			$this->companies->active();
			return redirect('/home')->with('message', 'New Company Selected.');
		}

        /**
         * Display the specified resource.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function show($id)
        {
            //
        }

        /**
         * Show the form for editing the specified resource.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function edit($id)
        {
            //
			
			 $data['title']	  = trans('app.company-update');
		     $data['currency'] =$this->companies->currency_data();
			 $data['update_com'] =$this->companies->company_update($id);
			return view('companies.edit',$data);
			
			
        }

        /**
         * Update the specified resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function update($id)
        {
                    if (\Input::file('logo') && \Input::file('logo')->isValid()) {
                        $destinationPath = './uploads/';
                        $filename = time().'.png';
                        \Input::file('logo')->move($destinationPath, $filename);
                        $logo = $filename;
                                        }
					$user_id=Auth::user()->id;;
					$name=Input::get('name');	
			        $currency=Input::get('currency');
                    $symbol=Input::get('symbol');
                    
                    if(isset($logo)){
                        DB::table('companies')
                        ->where('id', $id)
                        ->update(['user_id' => $user_id, 'name' => $name, 'currencies' => $currency, 'symbol' =>$symbol,'logo'=>$logo]); 
                    }
                    else{
					DB::table('companies')
					->where('id', $id)
					->update(['user_id' => $user_id, 'name' => $name, 'currencies' => $currency, 'symbol' =>$symbol]);
                     }
                    return redirect('/companies')->with('message', 'Company Updated.');
        }

        /**
         * Remove the specified resource from storage.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function destroy($id)
        {
            //
        }
		
		public function logo()
		{
			$data['log']=DB::select(DB::raw("
			SELECT *
			FROM companies"));
			return view('app',$data);
		}
		
		 
		public function get_symbol_value()
		{
			
			 $id= intval(Input::get('value'));
			
		   	 $symbol=DB::select(DB::raw("select * from currency where id=".$id." "));
			 

			foreach($symbol as $row){
			echo "<label for='unit' class='label-control'>Symbol</label>	
                    <input type='text' value='".$row->symbol."' class='form-control' name='symbol' >
                   "; 
			}
		}
		
		public function symbol_value()
		{
			
			 $id= intval(Input::get('value'));
			
		   	 $symbol=DB::select(DB::raw("select * from companies where id=".$id." "));
			 
			
			foreach($symbol as $row){
				if($row->id==$id)
				{ echo "<label for='unit' class='control-label'>Symbol</label>
                    <input type='text' value='".$row->symbol."' class='form-control' name='symbol'>"; 
			}}
		}
		
		
}
