<?php

namespace App\Http\Controllers;

use Auth, DB, Input;
use Illuminate\Http\Request;
use App\Periods;
use App\Categories;
use App\Budgets;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Http\Requests\CreatePeriodsRequest;
use App\Http\Requests\CreateCategoriesRequest;
use App\Http\Requests\CreateBudgetsRequest;

error_reporting(E_ALL);
class BudgetsController extends Controller
{
		/**
		 * Display a listing of the resource.
		 *
		 * @return \Illuminate\Http\Response
		 */
		protected $periods, $categories, $budgets, $colors;
		 
		public function __construct()
		{
			$this->middleware('auth');
			$this->periods 		= new Periods();
			$this->categories 	= new Categories();
			$this->budgets 		= new Budgets();
			$this->colors 		= \App\Providers\Common::colors();
		}

        public function index()
        {
                   
                    if(Auth::user()->company_id==NULL){
                        return redirect("/companies")->with("error", "Please Create/Select Your company first.");
                    }
                    if(Input::get('department')==false || Input::get('period')==false){
                       return redirect('/budgets?department=all&period=all'); 
                    }
                    $data['title']		= trans('budgets.title');
                    $data['period']		= Input::get('period');
                    $data['department']	= Input::get('department');
                    $data['budgets']	= $this->budgets->whereUser();
                    $data['info']		= $this->budgets->whereUserTotal();
                    $data['periods']	= $this->periods->whereUser();
                    $data['info']		= $data['info'][0];
                    $data['categories'] = $this->categories->whereUser();
                    $data['colors']		= $this->colors;
                    return View('budgets.index', $data);
        }

        /**
         * Show the form for creating a new resource.
         *
         * @return \Illuminate\Http\Response
         */
        public function create()
        {			
			if(Auth::user()->role==2){
				return redirect('/budgets?department=all&period=all')->with('error', 'Access denied you do not have sufficient privileges.');
			}
                    $data['title']			= trans('budgets.create');
                    $data['periods'] 		= $this->periods->whereUser();
                    $data['categories']    	= $this->categories->whereUser();
                    return View('budgets.create', $data);
        }

        /**
         * Store a newly created resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @return \Illuminate\Http\Response
         */
        public function store(CreateBudgetsRequest $request)
        {			
                    $budgets = new Budgets($request->all());
                    $budgets->user_id = Auth::user()->id;
                    $budgets->save();
                    return redirect('/budgets')->with('message', 'New Record Inserted.');
        }

        /**
         * Display the specified resource.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function show($id)
        {
            //
        }

        /**
         * Show the form for editing the specified resource.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function edit($id)
        {
            
			if(Auth::user()->role==2){
				return redirect('/budgets?department=all&period=all')->with('error', 'Access denied you do not have sufficient privileges.');
			}
                    if(Auth::user()->company_id==NULL){
                        return redirect("/companies")->with("error", "Please Create/Select Your comapny first.");
                    }
                
                   $data['budgets']	= $this->budgets->whereUser();
                 
                    $data['periods']	= $this->periods->whereUser();
                 
                    $data['categories'] = $this->categories->whereUser();
                 
					 $data['id']        =$id;
			        
			
			return View('budgets.edit',$data);
			
			
			
			
        }

        /**
         * Update the specified resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function update(Request $request, $id)
        {
            
			    $bud=$request->all(); 
			    $budget=Budgets::find($id);
                $budget->update($bud);
			    return redirect('/budgets?department=all&period=all')->with('message', 'Record Updated.');
			
        }

        /**
         * Remove the specified resource from storage.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        
		public function destroy($id)
        {
            //
        }
	
		public function budget_periods()
		{	
			
			
			$data['periods'] 		= $this->periods->whereUser();
			$data['title']			= trans('budgets.budget_periods');
			return View('budgets.budget_periods.periods_index', $data);
		
		}
		public function budget_categories()
		{	
			if(Auth::user()->role==3){
				return redirect('/expenses?department=all&status=all&period=all')->with('error', 'Access denied you do not have sufficient privileges.');
			}
			$data['categories']     = $this->categories->whereUser();
			//echo "<pre>"; print_r($data['categories'] ); exit;
			$data['title']			= trans('budgets.budget_periods');
			return View('budgets.budget_periods.categories_index', $data);
		
		}
	
		// Create Budget Periods Action
		public function periods_create(CreatePeriodsRequest $request)
		{	
			if(Auth::user()->role==2){
				return redirect('/budgets/periods')->with('error', 'Access denied you do not have sufficient privileges.');
			}
			
			$periods = new Periods($request->all());
			
			$periods['from'] = date("Y-m-d", strtotime($periods['from']));
			$periods['to'] = date("Y-m-d", strtotime($periods['to']));
			//echo "<pre>"; print_r($periods); exit;
			$periods->save();
			
			return redirect('/budgets/periods')->with('message', 'New Record Inserted.');
		
		}
		
		public function periods_show($id)
		{
			return Periods::find($id);
		}
		
		public function periods_delete($id)
		{
			if(Auth::user()->role==2){
			
			return redirect('budgets/periods')->with('error', 'Access denied you do not have sufficient privileges.');  					
			
			}
				
		    $del_period = DB::Select(DB::Raw("select * from budgets where company_id='".Auth::user()->company_id."' and period_id=".$id.";"));
			if(count($del_period) > 0){
					 	
		         foreach($del_period as $row){
						 
						 if($row->period_id >0 ){
					
					            return redirect('budgets/periods')->with('error', "You cannot delete period.It's already in use.");						 
					        }
					}
			}
			
			DB::table('periods')
			->where('id', '=', $id)
			->delete();

			return redirect('/budgets/periods')->with('error', 'Record Deleted!');
		}
		
		public function categories_create(CreateCategoriesRequest $request)
		{	
			if(Auth::user()->role==2){
						return redirect('budgets/categories')->with('error', 'Access denied you do not have sufficient privileges.');
			}
					
			$new_record=$this->check($request);
			
			if($new_record==true){
			
				 return redirect('/budgets/categories')->with('error', 'This Record already exit..');
			
			}else{   
					 $categories = new Categories($request->all());
					 $categories->save();
					 return redirect('/budgets/categories')->with('message', 'New Record Inserted.');
				}			
		}
		public function categories_delete($id)
		{
			if(Auth::user()->role==2 ){				
						return redirect('budgets/categories')->with('error', 'Access denied you do not have sufficient privileges.');	
			}
			$data['categories'] = $this->categories->whereUser();
			if(count($data['categories'])>0){
			   foreach($data['categories'] as $row){	
					 
					if($row->id==$id )
					{
						if($row->budgets>0)
						return redirect('budgets/categories')->with('error', "You cannot delete department.It's already in use.");						 
					}
				}
			}
			  
			DB::table('categories')
			->where('id','=', $id)
			->delete();
			return redirect('/budgets/categories')->with('error', 'Record Deleted!');
		   
		}
		
		
		public function check($request)
		{
			$category=DB::Select(DB::Raw("select name from categories where company_id='".Auth::user()->company_id."'"));	
			
			foreach($category as $row){
				if($request->name==$row->name){  
				
				  return true;
				
				} 
			}	
		}
		
		
		public function categories_update($id)
		{
			if(Auth::user()->role==2){
				return redirect('budgets/categories')->with('error', 'Access denied you do not have sufficient privileges.');
			}		
			$data['category_data']=DB::Select(DB::Raw("select id,name from categories where company_id='".Auth::user()->company_id."'"));
			$data['id']=$id; 			
			$data['periods'] 		= $this->periods->whereUser();
			$data['categories']     = $this->categories->whereUser();
			$data['title']			= trans('budgets.budget_periods');
				
			return View('budgets.budget_periods.update_category',$data); 		
			
		}
		
		public function update_category($id)
		{
			if(Auth::user()->role==2){
				return redirect('budgets/categories')->with('error', 'Access denied you do not have sufficient privileges.');
			}
			 $nam=Input::get('name');	
			 DB::table('categories')
			 ->where('id', $id)
			 ->update(['name' => $nam]);
			
			return redirect('/budgets/categories')->with('message', 'Record updated.');		
			
		}
			
			
		public function update_period($id)
		{
			if(Auth::user()->role==2){
				return redirect('/budgets/periods')->with('error', 'Access denied you do not have sufficient privileges.');
			}
			$data['periods_data']=DB::Select(DB::Raw("select * from periods where company_id='".Auth::user()->company_id."'"));
			$data['id']=$id; 			
			$data['periods'] = $this->periods->whereUser();
			$data['categories'] = $this->categories->whereUser();
			$data['title'] = trans('budgets.budget_periods');
				
			return View('budgets.budget_periods.update_period',$data); 		
			
		}
			
		public function period_update($id)
		{
			
			$to=Input::get('to');	
			$from=Input::get('from');
			$name=Input::get('name');
	   
			 
			DB::table('periods')
			->where('id', $id)
			->update(['to' => $to, 'from' => $from, 'name' => $name]);
			
				
			return redirect('/budgets/periods')->with('message', 'Record updated.');		
			
		}
		
		public function budget_delete($id)
		{
				
				$data['budget_data']=$this->budgets->budgets_data();
				
				if(Auth::user()->role==2){
						return redirect('/budgets?department=all&period=all')->with('error', 'Access denied you do not have sufficient privileges.');  					
					}
					
				if(count($data['budget_data'])>0){
					 foreach($data['budget_data'] as $row){	
						if($row->id==$id )
						{
							if($row->bud == $row->remaining)
							{  
									DB::table('budgets')
									->where('id', '=', $id)
									->delete();
								return redirect('/budgets?department=all&period=all')->with('error', 'Record Deleted!');						 
						 
						    }
						}
					}
				}
						
				return redirect('/budgets?department=all&period=all')->with('error', "You cannot delete budget.It's already in use.");
		
			}
					
		}
