<?php

namespace App\Http\Controllers\Auth;

use Input,
    Mail;
use App\User;
use Validator;
use App\Countries , App\States, App\Cities;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Foundation\Auth\AuthenticatesAndRegistersUsers;
error_reporting(E_ALL);
class AuthController extends Controller 
{
    /*
      |--------------------------------------------------------------------------
      | Registration & Login Controller
      |--------------------------------------------------------------------------
      |
      | This controller handles the registration of new users, as well as the
      | authentication of existing users. By default, this controller uses
      | a simple trait to add these behaviors. Why don't you explore it?
      |
     */

use AuthenticatesAndRegistersUsers,
    ThrottlesLogins;

    /**
     * Create a new authentication controller instance.
     *
     * @return void
     */
    public function __construct() {
        $this->countries = new Countries();
        $this->states    = new States();
        $this->cities    = new Cities();
        $this->middleware('guest', ['except' => 'getLogout']);
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data) {
        return Validator::make($data, [
                    'name' => 'required|max:255',
                    'email' => 'required|email|max:255|unique:users',
                    'password' => 'required|confirmed|min:6',
                    'phone'    => 'required',
                    'country' => 'required',
                    'state' => 'required',
                    'address' => 'required',
                    'post_code' => 'required',
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return User
     */
    protected function create(array $data) {
        return User::create([
                    'name' => $data['name'],
                    'email' => $data['email'],
                    'password' => bcrypt($data['password']),
                    'phone' => $data['phone'],
                    'country' => $data['country'],
                    'state' => $data['state'],
                    'city'  => $data['city'],
                    'address' => $data['address'],
                    'post_code' => $data['post_code'],
        ]);
    }

    public function getRegister() {
        $data['countries'] = $this->countries->all();
        return View('auth/register', $data);
    }

    public function get_zones() {
        $data['zones'] = $this->countries->zones();
        return View('auth/zones', $data);
    }

    public function get_states() {
        $id = $_GET['id'];
        $states = $this->countries->states($id);
        if(count($states)>0){
                foreach($states as $state){
                        echo '<option value="'.$state->id.'">'.$state->name.'</option>';
                }
        }
    }

    public function get_cities() {
        $id = $_GET['id'];
        $cities = $this->states->cities($id);
        if(count($cities)>0){
                foreach($cities as $city){
                        echo '<option value="'.$city->id.'">'.$city->name.'</option>';
                }
        }
}
}
