<?php

namespace App;

use Auth, DB, Input;
use Illuminate\Database\Eloquent\Model;
error_reporting(E_ALL);
class Expenses extends Model
{
	protected $fillable = ['expense_date','company_id', 'period_id', 'budget_id', 'priority', 'price', 'outside', 'subject', 'description', 'file'];
	
	
	public function getAll($id=NULL,$limit=NULL)
        { 
		$company_id		= Auth::user()->company_id;
		$department     = Input::get('department');
		$status 		= Input::get('status');
		$period 		= Input::get('period');
		$expense 		= Input::get('expense');
		$limit          = Input::get('limit');
		$table          = DB::table('expenses as e');
		$table          = $table->select('e.id', 'u.name as user', 'b.item', 'p.name as period', 'e.price', 'e.comments', 'e.priority', 'ca.name as category', 'e.status', 'e.outside as budget', 'app.name as approver', 'app.logo as approver_logo', 'e.created_at', 'e.updated_at', 'e.subject' , 'e.description', 'e.file','e.expense_date');
		$table          = $table->leftJoin('companies as c', 'e.company_id', '=', 'c.id');
		$table          = $table->leftJoin('budgets as b', 'b.id', '=', 'e.budget_id');
		$table          = $table->leftJoin('users as u', 'e.user_id', '=', 'u.id');
		$table          = $table->leftJoin('users as app', 'e.approver_id', '=', 'app.id');
		$table          = $table->leftJoin('categories as ca', 'ca.id', '=', 'b.category_id');
		$table          = $table->leftJoin('periods as p', 'e.period_id', '=', 'p.id');
		if($id==NULL){
			$table = $table->where('e.company_id', $company_id);
			// if(Auth::user()->role!=1){
			// 	$table = $table->whereIn('b.category_id', $this->user_companies());
			// }
			if($department && $department!="all")
				$table = $table->where('b.category_id', $department);
			if($status && $status!="all")
				$table = $table->where('e.status', $status);
			$table = $table->whereRaw('p.id = b.period_id');
			if($period && $period!="all")
				$table = $table->where('b.period_id', $period);
			// Search Bar Expense Request
			if($expense){
				$table = $table->where('e.id', 'like', $expense);
				$table = $table->orWhere('u.name', 'like', '%'.$expense.'%');
				$table = $table->orWhere('b.item', 'like', '%'.$expense.'%');
				$table = $table->orWhere('e.price', 'like', '%'.$expense.'%');
				$table = $table->orWhere('ca.name', 'like', '%'.$expense.'%');
				$table = $table->orWhere('e.status', 'like', '%'.$expense.'%');
				$table = $table->orWhere('e.outside', 'like', '%'.$expense.'%');
				$table = $table->orWhere('app.name', 'like', '%'.$expense.'%');
				$table = $table->orWhere('e.created_at', 'like', '%'.$expense.'%');
			}
			$table = $table->groupBy('e.id');
			$table = $table->orderBy('e.id', 'DESC');
			if($limit>0){
				return $table->skip(0)->take($limit)->get();	
			}else{
				return $table->paginate(15);
			}
			//return $table->paginate(15);
		}else{
			$table = $table->groupBy('e.id');
			$table = $table->where('e.id', $id);
			return $table->get();
		}
		
	}
	public function user_companies()
        {
		$company_id	= Auth::user()->company_id;
		$user_id	= Auth::user()->id;
		$table          = DB::table('user_companies');	
		$table->select('department_id');
		$table->where('user_id', $user_id);
		$table->where('company_id', $company_id);
		$result         = $table->get();
		$array          = [];
		if(count($result)>0):
		foreach($result as $row):
			$array[] = $row->department_id;
		endforeach;
		endif;
		return $array;
	}
	
	public function dashboard_data($userid,$companyid,$status)
        {
		$table	= DB::table('expenses');	
		$table->select('*');
		$table->where('user_id', $userid);
		$table->where('company_id', $companyid);
		$table->where('status', $status);
		$result = $table->count();
		
		return $result;
	}
	public function closeprojects($userid,$companyid)
        {
		$table	= DB::table('expenses');	
		$table->select('*');
		$table->where('user_id', $userid);
		$table->where('company_id', $companyid);
		$table->where('status', 'Pending');
		$result = $table->get();
		foreach($result as $row){
			$ExpenseID      = $row->id;
			$Priority       = $row->priority;
			$CreatedTime    = $row->created_at;
			$CurrentTime    = date('Y-m-d H:i:s');
			
			if($Priority == 'High'){
				$AddedTime = date( "Y-m-d H:i:s", strtotime( $CreatedTime ) + 6 * 3600 );
				if($CurrentTime >= $AddedTime){
					$Status = 'Overdue';
					$Comments = 'Time Over @ High Priority';
					$table = Expenses::find($ExpenseID);
					$table->status = $Status;
					$table->comments = $Comments;
					$result = $table->save(); 
				}
			} 
			if($Priority == 'Medium'){
				$AddedTime = date( "Y-m-d H:i:s", strtotime( $CreatedTime ) + 24 * 3600 );
				if($CurrentTime >= $AddedTime){
					$Status = 'Overdue';
					$Comments = 'Time Over @ Medium Priority';
					$table = Expenses::find($ExpenseID);
					$table->status = $Status;
					$table->comments = $Comments;
					$result = $table->save(); 
				}
			}
			if($Priority == 'Low'){
				$AddedTime = date( "Y-m-d H:i:s", strtotime( $CreatedTime ) + 48 * 3600 );
				if($CurrentTime >= $AddedTime){
					$Status = 'Overdue';
					$Comments = 'Time Over @ Low Priority';
					$table = Expenses::find($ExpenseID);
					$table->status = $Status;
					$table->comments = $Comments;
					$result = $table->save(); 
				}
			}
		} 
	}
	
	
	public function getAllExpensesHome($id=NULL)
        { 
		$company_id		= Auth::user()->company_id;
		$department     = Input::get('department');
		$status 	 	= Input::get('status');
		$period 	 	= Input::get('period');
		$expense 		= Input::get('expense');
		$limit          = Input::get('limit');
		$table          = DB::table('expenses as e');
		$table          = $table->select('e.id', 'u.name as user', 'b.item', 'p.id as period', 'e.price', 'e.comments', 'e.priority', 'ca.name as category', 'e.status', 'e.outside as budget', 'app.name as approver', 'app.logo as approver_logo', 'e.created_at', 'e.updated_at', 'e.subject', 'e.description', 'e.file');
		$table          = $table->leftJoin('companies as c', 'e.company_id', '=', 'c.id');
		$table          = $table->leftJoin('budgets as b', 'b.id', '=', 'e.budget_id');
		$table          = $table->leftJoin('users as u', 'e.user_id', '=', 'u.id');
		$table          = $table->leftJoin('users as app', 'e.approver_id', '=', 'app.id');
		$table          = $table->leftJoin('categories as ca', 'ca.id', '=', 'b.category_id');
		$table          = $table->leftJoin('periods as p', 'c.id', '=', 'p.company_id');
		if($id==NULL){
			$table = $table->where('e.company_id', $company_id);
			// if(Auth::user()->role!=1){
			// 	$table = $table->whereIn('b.category_id', $this->user_companies());
			// }
			if($department && $department!="all")
				$table = $table->where('b.category_id', $department);
			if($status && $status!="all")
				$table = $table->where('e.status', $status);
			$table = $table->whereRaw('p.id = b.period_id');
			if($period && $period!="all")
				$table = $table->where('b.period_id', $period);
			// Search Bar Expense Request
			if($expense){
				$table = $table->where('e.id', 'like', $expense);
				$table = $table->orWhere('u.name', 'like', '%'.$expense.'%');
				$table = $table->orWhere('b.item', 'like', '%'.$expense.'%');
				$table = $table->orWhere('e.price', 'like', '%'.$expense.'%');
				$table = $table->orWhere('ca.name', 'like', '%'.$expense.'%');
				$table = $table->orWhere('e.status', 'like', '%'.$expense.'%');
				$table = $table->orWhere('e.outside', 'like', '%'.$expense.'%');
				$table = $table->orWhere('app.name', 'like', '%'.$expense.'%');
				$table = $table->orWhere('e.created_at', 'like', '%'.$expense.'%');
			}
				$table = $table->groupBy('e.id');
				$table = $table->orderBy('e.id', 'DESC');
				return $table->skip(0)->take(10)->get();
			}else{
				$table = $table->groupBy('e.id');
				$table = $table->where('e.id', $id);
				return $table->get();
		}
	}	
	public static function chart($request)
	{
		
		$periods = "";
		if(isset($request->periods)){
			$periods = "AND p.id IN (".implode(",",$request->periods).")";
		}
		$department = "(SELECT IFNULL(SUM(b.budget),0) FROM  budgets b WHERE b.period_id=p.id AND b.company_id=p.company_id) AS budget,
			(SELECT IFNULL(SUM(e.price),0) FROM expenses e WHERE e.period_id=p.id AND e.company_id=p.company_id) AS expense";
		if(isset($request->department_id))
		{
			if($request->department_id!=0){
				$department = "(SELECT IFNULL(SUM(b.budget),0) FROM  budgets b WHERE b.period_id=p.id AND b.company_id=p.company_id AND b.category_id = ".$request->department_id.") AS budget,
			(SELECT IFNULL(SUM(e.price),0) FROM expenses e, budgets bu WHERE e.period_id=p.id AND e.company_id=p.company_id AND bu.id = e.budget_id AND bu.category_id = ".$request->department_id.") AS expense";
			}
		}
		$query = DB::raw("
			SELECT 
			p.id,p.`name`,
			".$department."
			
			FROM periods AS p
			WHERE p.company_id=".Auth::user()->company_id."		
			".$periods."
		");	      
		  $data = DB::select($query); 
		  return $data;
		  
		}

	public static function piechart()
	{
		$query = DB::raw("
		SELECT c.name, ifnull(SUM(e.price),0) AS amount
		FROM expenses e,categories c,budgets b
		WHERE b.category_id=c.id AND
		e.budget_id=b.id AND b.company_id= '".Auth::user()->company_id."'
		GROUP BY
		c.name
		");
	      
		  $data = DB::select($query);
		  
		  return $data;
		  
		}
		
	
		
		
		public static function filter_expense($dep,$per)
		{
		
		if($dep==0 && $per==0 ){
			
		  $sql=DB::raw("SELECT YEAR(e.expense_date) as y ,MONTH(e.expense_date) as mnt,
          pe.name as p_nam,
		  e.expense_date as ed,c.name as cat,e.subject as sub,e.price as e_price,e.status as sat  
		  FROM expenses as e join budgets as b on e.budget_id=b.id 
		  left join categories as c on b.category_id=c.id 
		  left join periods as pe on e.period_id=pe.id
		  where e.company_id='".Auth::user()->company_id."';");
		   
		   $query=DB::select($sql);
		   
		}else if($dep>0 && $per==0 ){
		
		 $sql=DB::raw("SELECT YEAR(e.expense_date) as y ,MONTH(e.expense_date) as mnt,
		 pe.name as p_nam,
		 e.expense_date as ed,c.name as cat,e.subject as sub,e.price as e_price,e.status as sat  
		 FROM expenses as e join budgets as b on e.budget_id=b.id 
		 left join categories as c on b.category_id=c.id 
		 left join periods as pe on e.period_id=pe.id
		 where e.company_id='".Auth::user()->company_id."' 
		 and c.id='".$dep."' ;");
		 
		 $query=DB::select($sql);	
			
		}else if($dep==0 && $per>0 ){
		
		 $sql=DB::raw("SELECT YEAR(e.expense_date) as y ,MONTH(e.expense_date) as mnt,
		 pe.name as p_nam,
		 e.expense_date as ed,c.name as cat,e.subject as sub,e.price as e_price,e.status as sat  
		 FROM expenses as e join budgets as b on e.budget_id=b.id 
		 left join categories as c on b.category_id=c.id 
		 left join periods as pe on e.period_id=pe.id
		 where e.company_id='".Auth::user()->company_id."'
		 and e.period_id='".$per."' ;");
		 
		 $query=DB::select($sql);	
			
		}else if($dep>0 && $per>0 ){
		
		 $sql=DB::raw("SELECT YEAR(e.expense_date) as y ,MONTH(e.expense_date) as mnt,
		 pe.name as p_nam,
		 e.expense_date as ed,c.name as cat,e.subject as sub,e.price as e_price,e.status as sat  
		 FROM expenses as e join budgets as b on e.budget_id=b.id 
		 left join categories as c on b.category_id=c.id 
		 left join periods as pe on e.period_id=pe.id
		 where e.company_id='".Auth::user()->company_id."' 
		 and c.id='".$dep."' 
		 and e.period_id='".$per."' ;");
		
		 $query=DB::select($sql);	
			
		}
		return $query;
		
		}		
}