<?php
namespace App;

use Auth, DB, Input;
use Illuminate\Database\Eloquent\Model;
error_reporting(E_ALL);
class Budgets extends Model
{
    protected $fillable = ['category_id', 'period_id', 'item', 'unit', 'quantity', 'budget', 'company_id'];
	public function user()
	{
		return $this->belongsTo('App\User');
	}
	public function whereUser()
    {
		$company_id	= Auth::user()->company_id;
		$department     = "";
		$period         = "";
		$AND            = "";
		
		if(Input::get('department') && Input::get('department')!="all"){
                    $department = "AND b.category_id = :category_id";
					$array["category_id"] = Input::get('department');
                }
		if(Input::get('period') && Input::get('period')!="all"){
                    $period = "AND b.period_id = :period_id";
					$array["period_id"] = Input::get('period');
                }
		// Get Data
		$array["company_id"] = $company_id;
		return DB::select(DB::raw("
			SELECT b.id id, b.company_id, u.name user, c.name category, p.name period, b.period_id, b.category_id , b.item, b.unit, b.quantity, b.budget, CASE WHEN (b.budget-SUM(e.price) > 0) THEN b.budget-SUM(e.price) ELSE b.budget END  outside, b.created_at, b.updated_at
			FROM budgets b
			LEFT JOIN categories c ON b.category_id = c.id
			LEFT JOIN periods p ON b.period_id = p.id
			LEFT JOIN companies co ON b.company_id = co.id
			LEFT JOIN users u ON b.user_id = u.id
			LEFT JOIN expenses e ON e.budget_id = b.id
			WHERE b.company_id = :company_id
			$department
			$period
			$AND
			GROUP BY b.id
			ORDER BY b.id ASC
		"), $array);	
	}
	public static function whereUserTotal()
    {
		$company_id	= Auth::user()->company_id;
		$department_expense     = "";
		$department_budget     = "";
		$period_expense         = "";
		$period_budget         = "";
		if(Input::get('department') && Input::get('department')!="all"){
					$department_id= Input::get('department');
                    $department_budget = "AND b.category_id = '".$department_id."'" ;
                    $department_expense = "AND e.category_id = '".$department_id."'";
					
                }
		if(Input::get('period') && Input::get('period')!="all"){
					$period_id = Input::get('period');
					$period_expense = "AND e.period_id = '".$period_id."'";
					$period_budget = "AND b.period_id = '".$period_id."'";
                }
		return DB::select(DB::raw("SELECT (
			SELECT ifnull(SUM(budget),0)
			FROM budgets b
			WHERE b.company_id ='".$company_id."' $period_budget $department_budget
			) total, (select ifnull(SUM(e.price),0) expense
			FROM expenses e
			WHERE e.company_id ='".$company_id."' AND e.`status` = 'Approved' $period_expense ) AS expense
		"));
	}
	public static function whereUserTotalhome()
    {
		$company_id	= Auth::user()->company_id;
		$department     = "";
		$period         = "";
		if(Input::get('department') && Input::get('department')!="all"){
                    $department = "AND b.category_id = :category_id";
					$array["category_id"] = Input::get('department');
                }
		if(Input::get('period') && Input::get('period')!="all"){
                    $period = "AND b.period_id = :period_id";
					$array["period_id"] = Input::get('period');
                }
		return DB::select(DB::raw("SELECT (
			SELECT ifnull(SUM(budget),0)
			FROM budgets
			WHERE company_id ='".$company_id."'
			) total, (select ifnull(SUM(e.price),0) expense
			FROM expenses e
			WHERE e.company_id ='".$company_id."' AND e.`status` = 'Approved') AS expense
			$department
			$period
		"));
	}

		
	
		
	public static function category()
	{
		 $category_names = DB::table('categories')->select('id', 'name')
		 ->where('company_id',Auth::user()->company_id)->get();
		 return $category_names;
	}
		
    public static function department_data($mon,$cat_id)
    {
 
		 $bu= DB::table('budgets')
		 ->where('category_id','=',$cat_id)
		 ->whereMonth('created_at','=',$mon)
		 ->whereYear('created_at','=',date('Y'))
		 ->sum('budget');
		 
		 return $bu;
	}
	

	public function budgets_data()
	{
	    $sql=DB::raw("SELECT 
			 b.id as id, b.budget as bud ,(select ifnull(sum(e.price),0) 
			 from expenses e where e.budget_id=b.id and e.status='Approved') as expense,
			 (b.budget -(select ifnull(sum(e.price),0) from expenses e where e.budget_id=b.id and e.status='Approved')) as remaining
			 FROM budgets as b left join categories as cat on b.category_id=cat.id 
			 left join companies as c on b.company_id=c.id 
			 left join periods as pe on b.period_id=pe.id 
			 where b.company_id='".Auth::user()->company_id."';");
	    
	    $query=DB::select($sql);
		return $query;
	
	}
	public static function filter_budget($dep,$per)
	{	
		if($dep==0 && $per==0 ){
			
			 $sql=DB::raw("SELECT YEAR(b.created_at) as y,MONTH(b.created_at) as month,
			 ct.name as cat,b.item as it , b.unit as un ,b.quantity as qn ,
			 b.budget as bud ,pe.name as p_nam,(select ifnull(sum(e.price),0) 
			 from expenses e where e.budget_id=b.id and e.status='Approved') as expense,
			 (b.budget -(select ifnull(sum(e.price),0) from expenses e where e.budget_id=b.id and e.status='Approved')) as remaining
			 FROM budgets as b left join categories as ct on b.category_id=ct.id 
			 left join companies as c on b.company_id=c.id 
			 left join periods as pe on b.period_id=pe.id 
			 where b.company_id='".Auth::user()->company_id."';");
			
			 $query=DB::select($sql);
			
		}else if($dep==0 && $per>0 ){
				
			$sql=DB::raw("SELECT YEAR(b.created_at) as y,b.period_id as month,
			ct.name as cat,b.item as it , b.unit as un ,
			b.quantity as qn ,b.budget as bud ,pe.name as p_nam ,
			(select ifnull(sum(e.price),0) 
			from expenses e where e.budget_id=b.id and e.status='Approved') as expense,
			(b.budget -(select ifnull(sum(e.price),0) from expenses e where e.budget_id=b.id and e.status='Approved')) as remaining
			FROM budgets as b left join categories as ct on b.category_id=ct.id 
			left join companies as c on b.company_id=c.id 
			left join periods as pe on b.period_id=pe.id 
			where b.company_id='".Auth::user()->company_id."'and b.period_id='".$per."' ;");
			
			$query=DB::select($sql);	
				
			}else if($dep>0 && $per==0 ){
				
			$sql=DB::raw("SELECT YEAR(b.created_at) as y,MONTH(b.created_at) as month,
			ct.name as cat,b.item as it , b.unit as un ,
			b.quantity as qn ,b.budget as bud ,pe.name as p_nam,
            (select ifnull(sum(e.price),0) 
			from expenses e where e.budget_id=b.id and e.status='Approved') as expense,
			(b.budget -(select ifnull(sum(e.price),0) from expenses e where e.budget_id=b.id and e.status='Approved')) as remaining			
			FROM budgets as b left join categories as ct on b.category_id=ct.id 
			left join companies as c on b.company_id=c.id 
			left join periods as pe on b.period_id=pe.id 
			where b.company_id='".Auth::user()->company_id."' 
			and ct.id='".$dep."' ;");
			
			$query=DB::select($sql);	
				
			}else if($dep>0 && $per>0 ){
				
			$sql=DB::raw("SELECT YEAR(b.created_at) as y,MONTH(b.created_at) as month,
			ct.name as cat,b.item as it , b.unit as un ,
			b.quantity as qn ,b.budget as bud ,pe.name as p_nam,
            (select ifnull(sum(e.price),0) 
			from expenses e where e.budget_id=b.id and e.status='Approved') as expense,
			(b.budget -(select ifnull(sum(e.price),0) from expenses e where e.budget_id=b.id and e.status='Approved')) as remaining			
			FROM budgets as b left join categories as ct on b.category_id=ct.id 
			left join companies as c on b.company_id=c.id 
			left join periods as pe on b.period_id=pe.id 
			where b.company_id='".Auth::user()->company_id."' and ct.id='".$dep."' 
			and b.period_id='".$per."'  ;");
			
			$query=DB::select($sql);	
				
			}
			
		return $query;

	}		
	

	
}