<style>
    .table {
        width: 100%;
        max-width: 100%;
        margin-bottom: 20px;
        display: table;
    }

    .text-left {
        text-align: left;
    }

    .text-right {
        text-align: right;
    }

    .text-center {
        text-align: center;
    }

    .text-justify {
        text-align: justify;
    }

    .pull-right {
        float: right !important;
    }

    span {
        font-weight: bold;
    }
</style>


<div>
    <h3 class="text-center">
        <?php if(!empty(\App\Models\Setting::where('setting_key','company_logo')->first()->setting_value)): ?>
            <img src="<?php echo e(url(asset('uploads/'.\App\Models\Setting::where('setting_key','company_logo')->first()->setting_value))); ?>"
                 class="img-responsive" width="150"/>

        <?php endif; ?>
    </h3>
    <h3 class="text-center">
        <span><?php echo e(\App\Models\Setting::where('setting_key','company_name')->first()->setting_value); ?></span></h3>

    <h3 class="text-center"><span> <?php echo e(trans_choice('general.receipt',1)); ?></span>
    </h3>
    <div style="margin-top:30px;margin-left: auto;margin-right: auto;text-transform: capitalize;font-size: 8px; clear: both; border-top:solid thin #ccc">
        <table class="table">
            <tr>
                <td><h2><span><?php echo e(trans_choice('general.borrower',1)); ?> <?php echo e(trans_choice('general.name',1)); ?></span></h2></td>
                <td class="text-right"><h2><?php echo e($loan_transaction->borrower->title); ?>

                        . <?php echo e($loan_transaction->borrower->first_name); ?> <?php echo e($loan_transaction->borrower->last_name); ?></h2>
                </td>
            </tr>
            <tr>
                <td><h2><span><?php echo e(trans_choice('general.loan',1)); ?> #</span></h2></td>
                <td class="text-right"><h2><?php echo e($loan_transaction->loan->id); ?></h2></td>
            </tr>
            <tr>
                <td><h2><span><?php echo e(trans_choice('general.transaction',1)); ?> <?php echo e(trans_choice('general.type',1)); ?></span></h2>
                </td>
                <td class="text-right">
                    <h2>
                        <?php if($loan_transaction->transaction_type=='disbursement'): ?>
                            <?php echo e(trans_choice('general.disbursement',1)); ?>

                        <?php endif; ?>
                        <?php if($loan_transaction->transaction_type=='specified_due_date'): ?>
                            <?php echo e(trans_choice('general.specified_due_date',2)); ?>   <?php echo e(trans_choice('general.fee',1)); ?>

                        <?php endif; ?>
                        <?php if($loan_transaction->transaction_type=='installment_fee'): ?>
                            <?php echo e(trans_choice('general.installment_fee',2)); ?>

                        <?php endif; ?>
                        <?php if($loan_transaction->transaction_type=='overdue_installment_fee'): ?>
                            <?php echo e(trans_choice('general.overdue_installment_fee',2)); ?>

                        <?php endif; ?>
                        <?php if($loan_transaction->transaction_type=='loan_rescheduling_fee'): ?>
                            <?php echo e(trans_choice('general.loan_rescheduling_fee',2)); ?>

                        <?php endif; ?>
                        <?php if($loan_transaction->transaction_type=='overdue_maturity'): ?>
                            <?php echo e(trans_choice('general.overdue_maturity',2)); ?>

                        <?php endif; ?>
                        <?php if($loan_transaction->transaction_type=='disbursement_fee'): ?>
                            <?php echo e(trans_choice('general.disbursement',1)); ?> <?php echo e(trans_choice('general.charge',2)); ?>

                        <?php endif; ?>
                        <?php if($loan_transaction->transaction_type=='interest'): ?>
                            <?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.applied',2)); ?>

                        <?php endif; ?>
                        <?php if($loan_transaction->transaction_type=='repayment'): ?>
                            <?php echo e(trans_choice('general.repayment',1)); ?>

                        <?php endif; ?>
                        <?php if($loan_transaction->transaction_type=='penalty'): ?>
                            <?php echo e(trans_choice('general.penalty',1)); ?>

                        <?php endif; ?>
                        <?php if($loan_transaction->transaction_type=='interest_waiver'): ?>
                            <?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.waiver',2)); ?>

                        <?php endif; ?>
                        <?php if($loan_transaction->transaction_type=='charge_waiver'): ?>
                            <?php echo e(trans_choice('general.charge',1)); ?>  <?php echo e(trans_choice('general.waiver',2)); ?>

                        <?php endif; ?>
                        <?php if($loan_transaction->transaction_type=='write_off'): ?>
                            <?php echo e(trans_choice('general.write_off',1)); ?>

                        <?php endif; ?>
                        <?php if($loan_transaction->transaction_type=='write_off_recovery'): ?>
                            <?php echo e(trans_choice('general.recovery',1)); ?> <?php echo e(trans_choice('general.repayment',1)); ?>

                        <?php endif; ?>

                    </h2>
                </td>
            </tr>
            <tr>
                <td><h2><span> <?php echo e(trans_choice('general.date',1)); ?>:</span></h2></td>
                <td class="text-right"><h2><?php echo e($loan_transaction->date); ?></h2></td>
            </tr>
            <tr>
                <td><h2><span><?php echo e(trans_choice('general.amount',1)); ?></span></h2></td>
                <td class="text-right">
                    <h2>
                        <?php if($loan_transaction->credit>$loan_transaction->debit): ?>
                            <?php echo e(number_format($loan_transaction->credit,2)); ?>

                        <?php else: ?>
                            <?php echo e(number_format($loan_transaction->debit,2)); ?>

                        <?php endif; ?>
                    </h2>
                </td>
            </tr>
            <tr>
                <td><h2><span><?php echo e(trans_choice('general.receipt',1)); ?></span></h2></td>
                <td class="text-right"><h2><?php echo e($loan_transaction->reference); ?></h2></td>
            </tr>
            <tr>
                <td><h2><span><?php echo e(trans_choice('general.balance',1)); ?></span></h2></td>
                <td class="text-right">
                    <h2><?php echo e(number_format(\App\Helpers\GeneralHelper::loan_total_balance($loan_transaction->loan->id),2)); ?></h2>
                </td>
            </tr>
            <tr>
                <td><h2><span><?php echo e(trans_choice('general.collected_by',1)); ?>:</span></h2></td>
                <td class="text-right">
                    <h2><?php echo e($loan_transaction->user->first_name); ?> <?php echo e($loan_transaction->user->last_name); ?></h2></td>
            </tr>
        </table>
        <p></p>
        <hr>
    </div>
</div>

