
<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.borrower',2)); ?> <?php echo e(trans_choice('general.pending',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="panel panel-white">
        <div class="panel-heading">
            <h6 class="panel-title"><?php echo e(trans_choice('general.borrower',2)); ?> <?php echo e(trans_choice('general.pending',1)); ?></h6>

            <div class="heading-elements">
                <?php if(Sentinel::hasAccess('borrowers.create')): ?>
                    <a href="<?php echo e(url('borrower/create')); ?>"
                       class="btn btn-info btn-sm"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.borrower',1)); ?></a>
                <?php endif; ?>
            </div>
        </div>
        <div class="panel-body ">
            <div class="table-responsive">
                <table id="data-table" class="table table-striped table-condensed table-hover">
                    <thead>
                    <tr>
                        <th><?php echo e(trans_choice('general.id',1)); ?></th>
                        <th><?php echo e(trans_choice('general.name',1)); ?></th>
                        <th><?php echo e(trans_choice('general.gender',1)); ?></th>
                        <th><?php echo e(trans_choice('general.mobile',1)); ?></th>
                        <th><?php echo e(trans_choice('general.status',1)); ?></th>
                        <th><?php echo e(trans_choice('general.action',1)); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key->id); ?></td>
                            <td><?php echo e($key->first_name); ?> <?php echo e($key->last_name); ?></td>
                            <td>
                                <?php if($key->gender=="Male"): ?>
                                    <?php echo e(trans_choice('general.male',1)); ?>

                                <?php endif; ?>
                                <?php if($key->gender=="Female"): ?>
                                    <?php echo e(trans_choice('general.female',1)); ?>

                                <?php endif; ?>
                            </td>
                            <td><?php echo e($key->mobile); ?></td>
                            <td>
                                <?php if($key->active==1): ?>
                                    <span class="label label-success"><?php echo e(trans_choice('general.active',1)); ?></span>
                                <?php endif; ?>
                                <?php if($key->active==0): ?>
                                    <span class="label label-danger"><?php echo e(trans_choice('general.pending',1)); ?></span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                                <ul class="icons-list">
                                    <li class="dropdown">
                                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                            <i class="icon-menu9"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-right" role="menu">
                                            <?php if($key->active==0): ?>
                                                <?php if(Sentinel::hasAccess('borrowers.approve')): ?>
                                                    <li><a href="<?php echo e(url('borrower/'.$key->id.'/approve')); ?>"><i
                                                                    class="fa fa-check"></i> <?php echo e(trans_choice('general.approve',1)); ?>

                                                        </a></li>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if($key->active==1): ?>
                                                <?php if(Sentinel::hasAccess('borrowers.approve')): ?>
                                                    <li><a href="<?php echo e(url('borrower/'.$key->id.'/decline')); ?>"><i
                                                                    class="fa fa-minus-circle"></i> <?php echo e(trans_choice('general.decline',1)); ?>

                                                        </a></li>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if(Sentinel::hasAccess('borrowers.blacklist')): ?>
                                                <?php if($key->blacklisted==1): ?>
                                                    <li><a href="<?php echo e(url('borrower/'.$key->id.'/unblacklist')); ?>"
                                                           class="delete"><i
                                                                    class="fa fa-check"></i><?php echo e(trans_choice('general.undo',1)); ?> <?php echo e(trans_choice('general.blacklist',1)); ?>

                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($key->blacklisted==0): ?>
                                                    <li>
                                                        <a href="<?php echo e(url('borrower/'.$key->id.'/blacklist')); ?>"
                                                           class="delete"><i
                                                                    class="fa fa-minus-circle"></i> <?php echo e(trans_choice('general.blacklist',1)); ?>

                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if(Sentinel::hasAccess('borrowers.view')): ?>
                                                <li><a href="<?php echo e(url('borrower/'.$key->id.'/show')); ?>"><i
                                                                class="fa fa-search"></i> <?php echo e(trans_choice('general.detail',2)); ?>

                                                    </a></li>
                                            <?php endif; ?>
                                            <?php if(Sentinel::hasAccess('borrowers.update')): ?>
                                                <li><a href="<?php echo e(url('borrower/'.$key->id.'/edit')); ?>"><i
                                                                class="fa fa-edit"></i> <?php echo e(trans('general.edit')); ?> </a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if(Sentinel::hasAccess('borrowers.delete')): ?>
                                                <li><a href="<?php echo e(url('borrower/'.$key->id.'/delete')); ?>"
                                                       class="delete"><i
                                                                class="fa fa-trash"></i> <?php echo e(trans('general.delete')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                </ul>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.panel-body -->
    </div>
    <!-- /.box -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>

    <script>
        $('#data-table').DataTable({
            "order": [[0, "desc"]],
            "columnDefs": [
                {"orderable": false, "targets": [5]}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>