
<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.journal',1)); ?> <?php echo e(trans_choice('general.entry',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="panel panel-white">
        <div class="panel-heading">
            <h6 class="panel-title">
                <?php echo e(trans_choice('general.journal',1)); ?> <?php echo e(trans_choice('general.entry',2)); ?>

                <?php if(!empty($start_date)): ?>
                    for period: <b><?php echo e($start_date); ?> to <?php echo e($end_date); ?></b>
                <?php endif; ?>
            </h6>

            <div class="heading-elements">
            </div>
        </div>
        <div class="panel-body hidden-print">
            <?php echo Form::open(array('url' => Request::url(), 'method' => 'post','class'=>'form-horizontal', 'name' => 'form')); ?>

            <div class="row">
                <div class="col-md-4">
                    <?php echo Form::label('start_date',trans_choice('general.start',1).' '.trans_choice('general.date',1),array('class'=>'')); ?>

                    <?php echo Form::text('start_date',$start_date, array('class' => 'form-control date-picker', 'placeholder'=>"",'required'=>'required')); ?>

                </div>
                <div class="col-md-4">
                    <?php echo Form::label('end_date',trans_choice('general.end',1).' '.trans_choice('general.date',1),array('class'=>'')); ?>

                    <?php echo Form::text('end_date',$end_date, array('class' => 'form-control date-picker', 'placeholder'=>"",'required'=>'required')); ?>

                </div>
                <div class="col-md-4">
                    <?php echo Form::label('account_id',trans_choice('general.chart_of_account',1),array('class'=>'')); ?>

                    <?php echo Form::select('account_id',$chart_of_accounts,$account_id, array('class' => 'form-control select2', 'placeholder'=>trans_choice('general.select',1),'required'=>'required')); ?>

                </div>
            </div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-xs-12">

                        <button type="submit" class="btn btn-success"><?php echo e(trans_choice('general.search',1)); ?>!
                        </button>

                        <a href="<?php echo e(Request::url()); ?>"
                           class="btn btn-danger"><?php echo e(trans_choice('general.reset',1)); ?>!</a>
                    </div>
                </div>
            </div>
            <?php echo Form::close(); ?>


        </div>
        <!-- /.panel-body -->

    </div>
    <!-- /.box -->
    <?php if(!empty($start_date)): ?>
        <div class="panel panel-white">
            <div class="panel-body ">
                <div class="table-responsive">
                    <table id="data-table" class="table table-striped table-condensed table-hover">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo e(trans_choice('general.transaction',1)); ?> <?php echo e(trans_choice('general.id',1)); ?></th>
                            <th><?php echo e(trans_choice('general.transaction',1)); ?> <?php echo e(trans_choice('general.type',1)); ?></th>
                            <th><?php echo e(trans_choice('general.date',1)); ?></th>
                            <th><?php echo e(trans_choice('general.account',1)); ?></th>
                            <th><?php echo e(trans_choice('general.debit',1)); ?></th>
                            <th><?php echo e(trans_choice('general.credit',1)); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($key->id); ?></td>
                                <td><?php echo e($key->reference); ?></td>
                                <td>
                                    <?php if($key->transaction_type=='disbursement'): ?>
                                        <?php echo e(trans_choice('general.disbursement',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='accrual'): ?>
                                        <?php echo e(trans_choice('general.accrual',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='deposit'): ?>
                                        <?php echo e(trans_choice('general.deposit',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='withdrawal'): ?>
                                        <?php echo e(trans_choice('general.withdrawal',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='manual_entry'): ?>
                                        <?php echo e(trans_choice('general.manual_entry',2)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='pay_charge'): ?>
                                        <?php echo e(trans_choice('general.pay',1)); ?>    <?php echo e(trans_choice('general.charge',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='transfer_fund'): ?>
                                        <?php echo e(trans_choice('general.transfer_fund',1)); ?> <?php echo e(trans_choice('general.charge',2)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='expense'): ?>
                                        <?php echo e(trans_choice('general.expense',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='payroll'): ?>
                                        <?php echo e(trans_choice('general.payroll',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='income'): ?>
                                        <?php echo e(trans_choice('general.income',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='penalty'): ?>
                                        <?php echo e(trans_choice('general.penalty',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='fee'): ?>
                                        <?php echo e(trans_choice('general.fee',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='close_write_off'): ?>
                                        <?php echo e(trans_choice('general.write',1)); ?>  <?php echo e(trans_choice('general.waiver',2)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='repayment_recovery'): ?>
                                        <?php echo e(trans_choice('general.repayment',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='repayment'): ?>
                                        <?php echo e(trans_choice('general.repayment',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='interest_accrual'): ?>
                                        <?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.accrual',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->transaction_type=='fee_accrual'): ?>
                                        <?php echo e(trans_choice('general.fee',1)); ?> <?php echo e(trans_choice('general.accrual',1)); ?>

                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($key->date); ?></td>
                                <td>
                                    <?php if(!empty($key->chart)): ?>
                                        <?php echo e($key->chart->name); ?>

                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(number_format($key->debit,2)); ?></td>
                                <td><?php echo e(number_format($key->credit,2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- /.panel-body -->
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>
        $('#data-table').DataTable({
            "order": [[0, "asc"]],
            "columnDefs": [
                {"orderable": false, "targets": []}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>