
<?php $__env->startSection('title'); ?>
    <?php echo e($borrower_group->name); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-4">
            <div class="panel panel-white">
                <div class="panel-heading">
                    <h6 class="panel-title"><?php echo e($borrower_group->name); ?></h6>
                    <div class="heading-elements">
                    </div>
                </div>
                <div class="panel-body">
                    <?php echo $borrower_group->notes; ?>

                </div>
                <!-- /.panel-body -->
                <div class="panel-footer">
                    <div class="heading-elements">
                        <span class="heading-text"> <?php echo e(trans_choice('general.created_at',1)); ?>

                            : <?php echo e($borrower_group->created_at); ?></span>
                    </div>
                </div>
            </div>
            <!-- /.box -->
        </div>
        <div class="col-md-8">
            <div class="panel panel-white">
                <div class="panel-heading">
                    <h6 class="panel-title"><?php echo e(trans_choice('general.borrower',2)); ?></h6>

                    <div class="heading-elements">
                        <?php if(Sentinel::hasAccess('borrowers.groups')): ?>
                            <a href="#" data-toggle="modal" data-target="#addBorrower"
                               class="btn btn-info btn-sm"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.borrower',1)); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table id="" class="table table-striped table-condensed table-hover basic-data-table">
                            <thead>
                            <tr>
                                <th><?php echo e(trans_choice('general.id',1)); ?></th>
                                <th><?php echo e(trans_choice('general.name',1)); ?></th>
                                <th><?php echo e(trans_choice('general.mobile',1)); ?></th>
                                <th><?php echo e(trans_choice('general.balance',1)); ?></th>
                                <th><?php echo e(trans_choice('general.action',1)); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $borrower_group->members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!empty($key->borrower)): ?>
                                    <tr>
                                        <td><?php echo e($key->borrower->id); ?></td>
                                        <td><?php echo e($key->borrower->first_name); ?> <?php echo e($key->borrower->last_name); ?></td>
                                        <td><?php echo e($key->borrower->mobile); ?></td>
                                        <td>
                                            <?php if(\App\Models\Setting::where('setting_key', 'currency_position')->first()->setting_value=='left'): ?>
                                                <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?> <?php echo e(round(\App\Helpers\GeneralHelper::borrower_loans_total_due($key->borrower_id),2)); ?>

                                            <?php else: ?>
                                                <?php echo e(round(\App\Helpers\GeneralHelper::borrower_loans_total_due($key->borrower_id),2)); ?>  <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <ul class="icons-list">
                                                    <li class="dropdown">
                                                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                                            <i class="icon-menu9"></i>
                                                        </a>
                                                        <ul class="dropdown-menu dropdown-menu-right" role="menu">
                                                            <?php if(Sentinel::hasAccess('borrowers.view')): ?>
                                                                <li>
                                                                    <a href="<?php echo e(url('borrower/'.$key->borrower->id.'/show')); ?>"><i
                                                                                class="fa fa-search"></i> <?php echo e(trans_choice('general.detail',2)); ?>

                                                                    </a></li>
                                                            <?php endif; ?>
                                                            <?php if(Sentinel::hasAccess('borrowers.update')): ?>
                                                                <li>
                                                                    <a href="<?php echo e(url('borrower/'.$key->borrower->id.'/edit')); ?>"><i
                                                                                class="fa fa-edit"></i> <?php echo e(trans('general.edit')); ?>

                                                                    </a>
                                                                </li>
                                                            <?php endif; ?>
                                                            <?php if(Sentinel::hasAccess('borrowers.groups')): ?>
                                                                <li>
                                                                    <a href="<?php echo e(url('borrower/group/'.$key->id.'/remove_borrower')); ?>"
                                                                       class="delete"><i
                                                                                class="fa fa-trash"></i> <?php echo e(trans('general.remove')); ?>

                                                                    </a>
                                                                </li>
                                                            <?php endif; ?>
                                                        </ul>
                                                    </li>
                                                </ul>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.panel-body -->

            </div>
            <!-- /.box -->
        </div>
    </div>
    <div class="modal fade" id="addBorrower">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">*</span></button>
                    <h4 class="modal-title"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.borrower',1)); ?></h4>
                </div>
                <?php echo Form::open(array('url' => url('borrower/group/'.$borrower_group->id.'/add_borrower'),'method'=>'post')); ?>

                <div class="modal-body">
                    <div class="form-group">
                        <div class="form-line">
                            <?php echo Form::label('borrower_id',trans_choice('general.borrower',1),array('class'=>' control-label')); ?>

                            <?php echo Form::select('borrower_id',$borrowers,null,array('class'=>' select2','placeholder'=>trans_choice('general.select',1),'required'=>'required')); ?>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-info"><?php echo e(trans_choice('general.save',1)); ?></button>
                    <button type="button" class="btn default"
                            data-dismiss="modal"><?php echo e(trans_choice('general.close',1)); ?></button>
                </div>
                <?php echo Form::close(); ?>

            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>