
<?php $__env->startSection('title'); ?>
    <?php echo e(trans('general.login')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="panel panel-body login-form">
        <?php if(Session::has('flash_notification.message')): ?>
            <script>toastr.<?php echo e(Session::get('flash_notification.level')); ?>('<?php echo e(Session::get("flash_notification.message")); ?>', 'Response Status')</script>
        <?php endif; ?>
        <?php if(isset($msg)): ?>
            <div class="alert alert-success">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <?php echo e($msg); ?>

            </div>
        <?php endif; ?>
        <?php if(isset($error)): ?>
            <div class="alert alert-error">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <?php echo e($error); ?>

            </div>
        <?php endif; ?>
        <?php if(count($errors) > 0): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
        <div class="text-center">
            <h3><?php echo e(\App\Models\Setting::where('setting_key','company_name')->first()->setting_value); ?></h3>
            <div class="icon-object border-slate-300 text-slate-300">
                <?php if(!empty(\App\Models\Setting::where('setting_key','company_logo')->first()->setting_value)): ?>
                    <img src="<?php echo e(url(asset('uploads/'.\App\Models\Setting::where('setting_key','company_logo')->first()->setting_value))); ?>"
                         class="" height="72"/>
                <?php else: ?>
                    <i class="icon-reading"></i>
                <?php endif; ?>
            </div>
        </div>
        <?php if(\App\Models\Setting::where('setting_key', 'allow_client_login')->first()->setting_value == 1): ?>
            <?php echo Form::open(array('url' => url('client'), 'method' => 'post', 'name' => 'form','class'=>'c-login-form')); ?>

            <div class="text-center">
                <h5 class="content-group-lg"><?php echo e(trans('general.login')); ?>

                    <small class="display-block"><?php echo e(\App\Models\Setting::where('setting_key','welcome_note')->first()->setting_value); ?></small>
                </h5>

            </div>
            <div class="form-group has-feedback has-feedback-left">
                <?php echo Form::text('username', null, array('class' => 'form-control', 'placeholder'=>trans_choice('general.username',1),'required'=>'required',"id"=>'username')); ?>

                <div class="form-control-feedback">
                    <i class="icon-user text-muted"></i>
                </div>
            </div>
            <div class="form-group has-feedback has-feedback-left">
                <?php echo Form::password('password', array('class' => 'form-control', 'placeholder'=>trans('general.password'),'required'=>'required')); ?>

                <div class="form-control-feedback">
                    <i class="icon-lock2 text-muted"></i>
                </div>
            </div>
            <div class="form-group login-options">
                <div class="row">
                    <div class="col-sm-6">
                        <label class="checkbox-inline">
                            <input type="checkbox" name="remember" class="styled">
                            <?php echo e(trans('general.remember')); ?>

                        </label>
                    </div>

                    <div class="col-sm-6 text-right">
                        <a href="<?php echo e(url('client/forgot_password')); ?>"
                           id="forget-password"><?php echo e(trans('general.forgot_password')); ?></a>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <button type="submit" class="btn bg-pink-400 btn-block"><?php echo e(trans('general.login')); ?> <i
                            class="icon-arrow-right14 position-right"></i></button>
            </div>
            <?php echo Form::close(); ?>

            <?php if(\App\Models\Setting::where('setting_key','allow_self_registration')->first()->setting_value==1): ?>
                <div class="content-divider text-muted form-group">
                    <span><?php echo e(trans('general.register_account_msg')); ?></span>
                </div>
                <a href="<?php echo e(url('client/register')); ?>"
                   class="btn btn-default btn-block content-group legitRipple"><?php echo e(trans('general.register')); ?></a>
            <?php endif; ?>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('client.auth', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>