
<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.saving',2)); ?> <?php echo e(trans_choice('general.account',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="panel panel-white">
        <div class="panel-heading">
            <h6 class="panel-title"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.saving',2)); ?> <?php echo e(trans_choice('general.account',1)); ?></h6>

            <div class="heading-elements">

            </div>
        </div>
        <?php echo Form::open(array('url' => url('saving/store'), 'method' => 'post', 'id' => 'savings_form',"enctype"=>"multipart/form-data", 'class' => 'form-horizontal')); ?>

        <div class="panel-body">
            <div class="form-group">
                <?php echo Form::label('borrower_id',trans_choice('general.borrower',1)." *",array('class'=>'col-sm-3 control-label')); ?>

                <div class="col-sm-5">
                    <?php echo Form::select('borrower_id',$borrowers,$borrower_id, array('class' => ' select2 form-control', 'placeholder'=>"Select",'required'=>'required','id'=>'borrower_id')); ?>

                </div>
                <div class="col-sm-4">
                    <i class="icon-info3" data-toggle="tooltip" title="Select the borrower here"></i>
                </div>
            </div>
            <div class="form-group">
                <?php echo Form::label('savings_product_id',trans_choice('general.product',1)." *",array('class'=>'col-sm-3 control-label')); ?>

                <div class="col-sm-5">
                    <?php echo Form::select('savings_product_id',$savings_products,null, array('class' => 'select2 form-control','required'=>'','id'=>'savings_product_id')); ?>

                </div>
                <div class="col-sm-4">
                    <i class="icon-info3" data-toggle="tooltip" title="Select the Savings product"></i>
                </div>
            </div>
            <div class="form-group">
                <?php echo Form::label('date',trans_choice('general.date',1)." *",array('class'=>'col-sm-3 control-label')); ?>

                <div class="col-sm-5">
                    <?php echo Form::text('date',date("Y-m-d"), array('class' => 'form-control date-picker', 'placeholder'=>"yyyy-mm-dd",'required'=>'required','id'=>'date')); ?>

                </div>
            </div>
            <div class="form-group">
                <?php echo Form::label('notes',trans_choice('general.note',2),array('class'=>'col-sm-3 control-label')); ?>

                <div class="col-sm-5">
                    <?php echo Form::textarea('notes',null, array('class' => 'form-control', 'rows'=>'2',)); ?>

                </div>
            </div>
            <p class="bg-navy color-palette"><?php echo e(trans_choice('general.charge',2)); ?></p>

            <div class="form-group" id="chargesDiv">
                <div style="display: none;" id="saved_charges">
                    <?php $__currentLoopData = $savings_product->charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <input name="charges[]" id="charge<?php echo e($key->charge_id); ?>" value="<?php echo e($key->charge_id); ?>">
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <table class="table table-bordered">
                    <thead>
                    <tr>
                        <th><?php echo e(trans_choice('general.name',1)); ?></th>
                        <th><?php echo e(trans_choice('general.type',1)); ?></th>
                        <th><?php echo e(trans_choice('general.amount',1)); ?></th>
                        <th><?php echo e(trans_choice('general.collected',1)); ?> <?php echo e(trans_choice('general.on',1)); ?></th>
                        <th><?php echo e(trans_choice('general.date',1)); ?></th>
                    </tr>
                    </thead>
                    <tbody id="charges_table">
                    <?php $__currentLoopData = $savings_product->charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(!empty($key->charge)): ?>
                            <tr id="row<?php echo e($key->charge->id); ?>">
                                <td><?php echo e($key->charge->name); ?></td>
                                <td>
                                    <?php if($key->charge->charge_option=="fixed"): ?>
                                        <?php echo e(trans_choice('general.fixed',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->charge->charge_option=="principal_due"): ?>
                                        % <?php echo e(trans_choice('general.principal',1)); ?> <?php echo e(trans_choice('general.due',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->charge->charge_option=="principal_interest"): ?>
                                        % <?php echo e(trans_choice('general.principal',1)); ?>

                                        + <?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.due',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->charge->charge_option=="interest_due"): ?>
                                        % <?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.due',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->charge->charge_option=="total_due"): ?>
                                        % <?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.due',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->charge->charge_option=="original_principal"): ?>
                                        % <?php echo e(trans_choice('general.original',1)); ?> <?php echo e(trans_choice('general.principal',1)); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($key->charge->override==1): ?>
                                        <input type="text" class="form-control"
                                               name="charge_amount_<?php echo e($key->charge->id); ?>"
                                               value="<?php echo e($key->charge->amount); ?>" required>
                                    <?php else: ?>
                                        <input  type="hidden" class="form-control"
                                                name="charge_amount_<?php echo e($key->charge->id); ?>"
                                                value="<?php echo e($key->charge->amount); ?>">
                                        <?php echo e($key->charge->amount); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($key->charge->charge_type=='disbursement'): ?>
                                        <?php echo e(trans_choice('general.disbursement',1)); ?>

                                    <?php endif; ?>
                                    <?php if($key->charge->charge_type=='specified_due_date'): ?>
                                        <?php echo e(trans_choice('general.specified_due_date',2)); ?>

                                    <?php endif; ?>
                                    <?php if($key->charge->charge_type=='installment_fee'): ?>
                                        <?php echo e(trans_choice('general.installment_fee',2)); ?>

                                    <?php endif; ?>
                                    <?php if($key->charge->charge_type=='overdue_installment_fee'): ?>
                                        <?php echo e(trans_choice('general.overdue_installment_fee',2)); ?>

                                    <?php endif; ?>
                                    <?php if($key->charge->charge_type=='loan_rescheduling_fee'): ?>
                                        <?php echo e(trans_choice('general.loan_rescheduling_fee',2)); ?>

                                    <?php endif; ?>
                                    <?php if($key->charge->charge_type=='overdue_maturity'): ?>
                                        <?php echo e(trans_choice('general.overdue_maturity',2)); ?>

                                    <?php endif; ?>
                                    <?php if($key->charge->charge_type=='savings_activation'): ?>
                                        <?php echo e(trans_choice('general.savings_activation',2)); ?>

                                    <?php endif; ?>
                                    <?php if($key->charge->charge_type=='withdrawal_fee'): ?>
                                        <?php echo e(trans_choice('general.withdrawal_fee',2)); ?>

                                    <?php endif; ?>
                                    <?php if($key->charge->charge_type=='monthly_fee'): ?>
                                        <?php echo e(trans_choice('general.monthly_fee',2)); ?>

                                    <?php endif; ?>
                                    <?php if($key->charge->charge_type=='annual_fee'): ?>
                                        <?php echo e(trans_choice('general.annual_fee',2)); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($key->charge->charge_type=='specified_due_date'): ?>
                                        <input type="text" class="form-control date-picker"
                                               name="charge_date_<?php echo e($key->charge->id); ?>"
                                               value="" required>
                                    <?php else: ?>
                                        <input  type="hidden" class="form-control"
                                                name="charge_date_<?php echo e($key->charge->id); ?>"
                                                value="">
                                    <?php endif; ?>
                                </td>

                            </tr>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.panel-body -->
        <div class="panel-footer">
            <div class="heading-elements">
                <button type="submit" class="btn btn-primary pull-right"><?php echo e(trans_choice('general.save',1)); ?></button>
            </div>
        </div>
        <?php echo Form::close(); ?>

    </div>
    <!-- /.box -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer-scripts'); ?>
    <script>
        $(document).ready(function () {

            $('#savings_product_id').change(function (e) {
                window.location = "<?php echo url('saving/create?product_id='); ?>" + $("#savings_product_id").val()+"&borrower_id="+ $("#borrower_id").val();
            })

        });
    </script>
    <script>
        $("#savings_form").validate({
            rules: {
                field: {
                    required: true,
                    number: true
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>