
<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.collateral',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="panel panel-white">
        <div class="panel-heading">
            <h6 class="panel-title"><?php echo e(trans_choice('general.collateral',1)); ?> </h6>

            <div class="heading-elements">

            </div>
        </div>
        <div class="panel-body">
            <div class="">
                <table id="data-table" class="table table-striped table-condensed table-hover">
                    <thead>
                    <tr >
                        <th><?php echo e(trans_choice('general.type',1)); ?></th>
                        <th><?php echo e(trans_choice('general.name',1)); ?></th>
                        <th><?php echo e(trans_choice('general.borrower',1)); ?></th>
                        <th><?php echo e(trans_choice('general.loan',1)); ?></th>
                        <th><?php echo e(trans_choice('general.value',1)); ?></th>
                        <th><?php echo e(trans_choice('general.status',1)); ?></th>
                        <th><?php echo e(trans_choice('general.date',1)); ?></th>
                        <th><?php echo e(trans_choice('general.action',1)); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <?php if(!empty($key->collateral_type)): ?>
                                    <?php echo e($key->collateral_type->name); ?>

                                <?php endif; ?>
                            </td>
                            <td><?php echo e($key->name); ?></td>
                            <td>
                                <?php if(!empty($key->borrower)): ?>
                                    <a href="<?php echo e(url('borrower/'.$key->borrower_id.'/show')); ?>"> <?php echo e($key->borrower->first_name); ?> <?php echo e($key->borrower->last_name); ?></a>
                                <?php endif; ?>
                            </td>
                            <td><a href="<?php echo e(url('loan/'.$key->loan_id.'/show')); ?>"># <?php echo e($key->loan_id); ?></a></td>
                            <td><?php echo e($key->value); ?></td>
                            <td>
                                <?php if($key->status=='deposited_into_branch'): ?>
                                    <?php echo e(trans_choice('general.deposited_into_branch',1)); ?>

                                <?php endif; ?>
                                <?php if($key->status=='collateral_with_borrower'): ?>
                                    <?php echo e(trans_choice('general.collateral_with_borrower',1)); ?>

                                <?php endif; ?>
                                <?php if($key->status=='returned_to_borrower'): ?>
                                    <?php echo e(trans_choice('general.returned_to_borrower',1)); ?>

                                <?php endif; ?>
                                <?php if($key->status=='repossession_initiated'): ?>
                                    <?php echo e(trans_choice('general.repossession_initiated',1)); ?>

                                <?php endif; ?>
                                <?php if($key->status=='repossessed'): ?>
                                    <?php echo e(trans_choice('general.repossessed',1)); ?>

                                <?php endif; ?>
                                <?php if($key->status=='sold'): ?>
                                    <?php echo e(trans_choice('general.sold',1)); ?>

                                <?php endif; ?>
                                <?php if($key->status=='lost'): ?>
                                    <?php echo e(trans_choice('general.lost',1)); ?>

                                <?php endif; ?>
                            </td>
                            <td><?php echo e($key->date); ?></td>
                            <td>
                                <ul class="icons-list">
                                    <li class="dropdown">
                                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                            <i class="icon-menu9"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-right">
                                            <?php if(Sentinel::hasAccess('collateral.view')): ?>
                                                <li><a href="<?php echo e(url('collateral/'.$key->id.'/show')); ?>"><i
                                                                class="fa fa-search"></i> <?php echo e(trans('general.view')); ?>

                                                    </a></li>
                                            <?php endif; ?>
                                            <?php if(Sentinel::hasAccess('collateral.update')): ?>
                                                <li><a href="<?php echo e(url('collateral/'.$key->id.'/edit')); ?>"><i
                                                                class="fa fa-edit"></i> <?php echo e(trans('general.edit')); ?> </a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if(Sentinel::hasAccess('collateral.delete')): ?>
                                                <li><a href="<?php echo e(url('collateral/'.$key->id.'/delete')); ?>"
                                                       class="delete"><i
                                                                class="fa fa-trash"></i> <?php echo e(trans('general.delete')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                </ul>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.panel-body -->
    </div>
    <!-- /.box -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>

    <script>

        $('#data-table').DataTable({

            "order": [[6, "desc"]],
            "columnDefs": [
                {"orderable": false, "targets": [7]}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>