
<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.product',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="panel panel-white">
        <div class="panel-heading">
            <h6 class="panel-title"><?php echo e(trans_choice('general.product',2)); ?> </h6>

            <div class="heading-elements">
                <?php if(Sentinel::hasAccess('stock.create')): ?>
                    <a href="<?php echo e(url('product/create')); ?>"
                       class="btn btn-info btn-sm"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.product',1)); ?> </a>
                <?php endif; ?>
            </div>
        </div>
        <div class="panel-body">
            <div class="row">
                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="panel panel-body bg-blue-400 has-bg-image">
                        <div class="media no-margin">
                            <div class="media-body">
                                <h3 class="no-margin"><?php echo e(\App\Models\Product::sum('qty')); ?></h3>
                                <span class="text-uppercase text-size-mini"><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.item',2)); ?></span>
                            </div>

                            <div class="media-right media-middle">
                                <i class="icon-cube3 icon-3x opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="clearfix visible-sm-block"></div>
                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="panel panel-body bg-green-400 has-bg-image">
                        <div class="media no-margin">
                            <div class="media-body">
                                <?php if(\App\Models\Setting::where('setting_key', 'currency_position')->first()->setting_value=='left'): ?>
                                    <h3 class="no-margin"> <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?><?php echo e(number_format(\App\Helpers\GeneralHelper::stock_total_cost_amount(),2)); ?> </h3>
                                <?php else: ?>
                                    <h3 class="no-margin"> <?php echo e(number_format(\App\Helpers\GeneralHelper::stock_total_cost_amount(),2)); ?>  <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?></h3>
                                <?php endif; ?>
                                <span class="text-uppercase text-size-mini"><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.cost',1)); ?> <?php echo e(trans_choice('general.value',1)); ?></span>
                            </div>
                            <div class="media-right media-middle">
                                <i class="icon-files-empty icon-3x opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="panel panel-body bg-green-400 has-bg-image">
                        <div class="media no-margin">
                            <div class="media-body">
                                <?php if(\App\Models\Setting::where('setting_key', 'currency_position')->first()->setting_value=='left'): ?>
                                    <h3 class="no-margin"> <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?><?php echo e(number_format(\App\Helpers\GeneralHelper::stock_total_selling_amount(),2)); ?> </h3>
                                <?php else: ?>
                                    <h3 class="no-margin"> <?php echo e(number_format(\App\Helpers\GeneralHelper::stock_total_selling_amount(),2)); ?>  <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?></h3>
                                <?php endif; ?>
                                <span class="text-uppercase text-size-mini"><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.selling',1)); ?> <?php echo e(trans_choice('general.value',1)); ?></span>
                            </div>
                            <div class="media-right media-middle">
                                <i class="icon-coin-dollar icon-3x opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="panel panel-body bg-blue-400 has-bg-image">
                        <div class="media no-margin">
                            <div class="media-body">
                                <?php if(\App\Models\Setting::where('setting_key', 'currency_position')->first()->setting_value=='left'): ?>
                                    <h3 class="no-margin"> <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?><?php echo e(number_format(\App\Helpers\GeneralHelper::stock_total_selling_amount()-\App\Helpers\GeneralHelper::stock_total_cost_amount(),2)); ?> </h3>
                                <?php else: ?>
                                    <h3 class="no-margin"> <?php echo e(number_format(\App\Helpers\GeneralHelper::stock_total_selling_amount()-\App\Helpers\GeneralHelper::stock_total_cost_amount(),2)); ?>  <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?></h3>
                                <?php endif; ?>
                                <span class="text-uppercase text-size-mini"><?php echo e(trans_choice('general.expected',1)); ?> <?php echo e(trans_choice('general.profit',2)); ?></span>
                            </div>
                            <div class="media-right media-middle">
                                <i class="icon-wallet icon-3x opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
            <div class="table-responsive">
                <table id="data-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th><?php echo e(trans_choice('general.id',1)); ?></th>
                        <th><i class="fa fa-picture-o"></i></th>
                        <th><?php echo e(trans_choice('general.name',1)); ?></th>
                        <th><?php echo e(trans_choice('general.code',1)); ?></th>
                        <th><?php echo e(trans_choice('general.qty',1)); ?></th>
                        <th><?php echo e(trans_choice('general.alert',1)); ?> <?php echo e(trans_choice('general.on',1)); ?></th>
                        <th><?php echo e(trans_choice('general.cost_price',1)); ?></th>
                        <th><?php echo e(trans_choice('general.selling_price',1)); ?></th>
                        <th><?php echo e(trans_choice('general.category',2)); ?></th>
                        <th><?php echo e(trans_choice('general.action',1)); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key->id); ?></td>
                            <td>
                                <?php if(!empty($key->picture)): ?>
                                    <a class="fancybox" rel="group"
                                       href="<?php echo e(url(asset('uploads/'.$key->picture))); ?>"> <img
                                                src="<?php echo e(url(asset('uploads/'.$key->picture))); ?>"
                                                style="max-width: 40px!important;"/></a>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($key->name); ?></td>
                            <td><?php echo e($key->code); ?></td>
                            <td><?php echo e($key->qty); ?></td>
                            <td><?php echo e($key->alert_qty); ?></td>
                            <td>
                                <?php if(\App\Models\Setting::where('setting_key', 'currency_position')->first()->setting_value=='left'): ?>
                                    <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?><?php echo e(number_format($key->cost_price,2)); ?>

                                <?php else: ?>
                                    <?php echo e(number_format($key->cost_price,2)); ?><?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?>

                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if(\App\Models\Setting::where('setting_key', 'currency_position')->first()->setting_value=='left'): ?>
                                    <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?><?php echo e(number_format($key->selling_price,2)); ?>

                                <?php else: ?>
                                    <?php echo e(number_format($key->selling_price,2)); ?><?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?>

                                <?php endif; ?>
                            </td>
                            <td>
                                <?php
                                $c = 1;
                                ?>
                                <?php $__currentLoopData = $key->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(!empty($category->category)): ?>
                                        <a href="#"><?php echo e($category->category->name); ?></a>
                                        <?php if(count($key->categories)!=$c): ?>
                                            ,
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php
                                    $c++;
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td>
                                <ul class="icons-list">
                                    <li class="dropdown">
                                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                            <i class="icon-menu9"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-right">
                                            <?php if(Sentinel::hasAccess('stock.view')): ?>
                                                <li><a href="<?php echo e(url('product/'.$key->id.'/show')); ?>"><i
                                                                class="fa fa-search"></i> <?php echo e(trans_choice('general.detail',1)); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if(Sentinel::hasAccess('stock.update')): ?>
                                                <li><a href="<?php echo e(url('product/'.$key->id.'/edit')); ?>"><i
                                                                class="fa fa-edit"></i> <?php echo e(trans('general.edit')); ?> </a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if(Sentinel::hasAccess('stock.delete')): ?>
                                                <li><a href="<?php echo e(url('product/'.$key->id.'/delete')); ?>"
                                                       class="delete"><i
                                                                class="fa fa-trash"></i> <?php echo e(trans('general.delete')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                </ul>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.panel-body -->
    </div>
    <!-- /.box -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>
        $('#data-table').DataTable({
            "order": [[0, "asc"]],
            "columnDefs": [
                {"orderable": false, "targets": [9]}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>